/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.drone.impl.InjectionPoints;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.impl.Validate;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.command.PrepareDrone;
import org.jboss.arquillian.drone.spi.event.DroneLifecycleEvent;
import org.jboss.arquillian.test.spi.TestEnricher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneTestEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(DroneTestEnricher.class.getName());
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Event<PrepareDrone> prepareDroneCommand;
    @Inject
    private Event<DroneLifecycleEvent> droneLifecycleEvent;

    public void enrich(Object testCase) {
        DroneContext context = (DroneContext)this.droneContext.get();
        Map<Field, DronePoint<?>> injectionPoints = InjectionPoints.fieldsInClass((DroneContext)this.droneContext.get(), testCase.getClass());
        for (Field field : injectionPoints.keySet()) {
            if (SecurityActions.getFieldValue(testCase, field) != null) {
                log.log(Level.FINER, "Skipped injection of field {0}", field.getName());
                continue;
            }
            DronePoint<?> dronePoint = injectionPoints.get(field);
            this.ensureInjectionPointPrepared(dronePoint);
            log.log(Level.FINE, "Injecting @Drone for field {0}, injection point {1}", new Object[]{dronePoint.getDroneType().getSimpleName(), dronePoint});
            Object drone = context.get(dronePoint).getInstance();
            Validate.stateNotNull(drone, "Retrieved a null from Drone Context, which is not a valid Drone browser object. \nClass: {0}, field: {1}, injection point: {2}", testCase.getClass().getName(), field.getName(), dronePoint);
            SecurityActions.setFieldValue(testCase, field, drone);
        }
    }

    public Object[] resolve(Method method) {
        DroneContext context = (DroneContext)this.droneContext.get();
        DronePoint<?>[] dronePoints = InjectionPoints.parametersInMethod((DroneContext)this.droneContext.get(), method);
        Object[] resolution = new Object[dronePoints.length];
        for (int i = 0; i < dronePoints.length; ++i) {
            DronePoint<?> dronePoint = dronePoints[i];
            if (dronePoint == null) {
                resolution[i] = null;
                continue;
            }
            this.ensureInjectionPointPrepared(dronePoint);
            log.log(Level.FINE, "Injecting @Drone for method {0}, injection point {1}", new Object[]{method.getName(), dronePoint});
            Object drone = context.get(dronePoint).getInstance();
            Validate.stateNotNull(drone, "Retrieved a null from Drone Context, which is not a valid Drone browser object.\nMethod: {0}, injection point: {1},", method.getName(), dronePoint);
            resolution[i] = drone;
        }
        return resolution;
    }

    private void ensureInjectionPointPrepared(DronePoint<?> dronePoint) {
        if (!((DroneContext)this.droneContext.get()).get(dronePoint).hasFutureInstance()) {
            if (dronePoint.getLifecycle() != DronePoint.Lifecycle.DEPLOYMENT) {
                log.log(Level.WARNING, "Injection point {0} was not prepared yet. It will be prepared now, but it''s recommended that all drones with class lifecycle are prepared in @BeforeClass!", dronePoint);
                this.prepareDroneCommand.fire((Object)new PrepareDrone(dronePoint));
            } else {
                throw new IllegalStateException(MessageFormat.format("Injection point {0} has deployment lifecycle and has to be prepared in @BeforeClass.", dronePoint));
            }
        }
    }
}

