/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.selenium.server.impl;

import java.io.IOException;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.selenium.server.configuration.SeleniumServerConfiguration;
import org.jboss.arquillian.drone.selenium.server.event.SeleniumServerConfigured;
import org.jboss.arquillian.drone.selenium.server.event.SeleniumServerStarted;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;

public class SeleniumServerCreator {
    @Inject
    private Instance<SeleniumServerConfiguration> seleniumServerConfiguration;
    @Inject
    private Event<SeleniumServerStarted> afterStart;
    @Inject
    @SuiteScoped
    private InstanceProducer<SeleniumServer> seleniumServer;

    public void seleniumServerStartUp(@Observes SeleniumServerConfigured event) throws IOException {
        if (!((SeleniumServerConfiguration)this.seleniumServerConfiguration.get()).isEnable()) {
            return;
        }
        SeleniumServerConfiguration configuration = (SeleniumServerConfiguration)this.seleniumServerConfiguration.get();
        RemoteControlConfiguration rcc = new RemoteControlConfiguration();
        rcc.setPort(configuration.getPort());
        rcc.setLogOutFileName(configuration.getOutput());
        try {
            SeleniumServer server = new SeleniumServer(rcc);
            server.start();
            this.seleniumServer.set((Object)server);
            this.afterStart.fire((Object)new SeleniumServerStarted());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start Selenium Server", e);
        }
    }
}

