/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.selenium.server.configuration;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static List<Field> getAccessableFields(final Class<?> source) {
        List<Field> declaredAccessableFields = AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> foundFields = new ArrayList<Field>();
                for (Field field : source.getDeclaredFields()) {
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    foundFields.add(field);
                }
                return foundFields;
            }
        });
        return declaredAccessableFields;
    }

    static String getProperty(final String key) {
        try {
            String value = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return value;
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof SecurityException) {
                throw (SecurityException)t;
            }
            if (t instanceof NullPointerException) {
                throw (NullPointerException)t;
            }
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }
}

