/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.selenium.server.impl;

import java.io.File;
import java.io.IOException;

public final class Validate {
    private Validate() {
    }

    public static void notNull(Object obj, String message) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrEmpty(String string, String message) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isNotNullOrEmpty(String string) throws IllegalArgumentException {
        return string != null && string.length() != 0;
    }

    public static void stateNotNull(Object obj, String message) throws IllegalStateException {
        if (obj == null) {
            throw new IllegalStateException(message);
        }
    }

    public static void isValidFile(String path, String message) throws IllegalArgumentException {
        Validate.notNull(path, message);
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isInReadableDirectory(String path, String message) throws IllegalArgumentException {
        Validate.notNull(path, message);
        File file = new File(path);
        try {
            if (!file.createNewFile() && !file.canRead()) {
                throw new IllegalArgumentException(message);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(message, e);
        }
    }
}

