/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.selenium.server.configuration;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.drone.configuration.ConfigurationMapper;
import org.jboss.arquillian.drone.selenium.server.configuration.SecurityActions;
import org.jboss.arquillian.drone.spi.DroneConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeleniumServerConfiguration
implements DroneConfiguration<SeleniumServerConfiguration> {
    public static final String CONFIGURATION_NAME = "selenium-server";
    private boolean avoidProxy = false;
    private boolean browserSessionReuse = false;
    private boolean browserSideLog = false;
    private boolean debug = false;
    private boolean dontTouchLogging = false;
    private boolean ensureCleanSession = false;
    private String firefoxProfileTemplate;
    private String forcedBrowserMode;
    private boolean honorSystemProxy = false;
    private String host = "localhost";
    private String logFile;
    private String nonProxyHosts = SecurityActions.getProperty("http.nonProxyHosts");
    private int port = 14444;
    private String profilesLocation;
    private String proxyHost = SecurityActions.getProperty("http.proxyHost");
    private boolean proxyInjectionMode = false;
    private String proxyPort = SecurityActions.getProperty("http.proxyPort");
    private int retryTimeoutInSeconds = 10;
    private boolean singleWindow = false;
    private boolean skip = false;
    private String systemProperties;
    private int timeoutInSeconds = Integer.MAX_VALUE;
    private boolean trustAllSSLCertificates = false;
    private String trustStore = SecurityActions.getProperty("javax.net.ssl.trustStore");
    private String trustStorePassword = SecurityActions.getProperty("javax.net.ssl.trustStorePassword");
    private String userExtensions;

    public SeleniumServerConfiguration configure(ArquillianDescriptor descriptor, Class<? extends Annotation> qualifier) {
        ConfigurationMapper.fromArquillianDescriptor((ArquillianDescriptor)descriptor, (DroneConfiguration)this, qualifier);
        return (SeleniumServerConfiguration)ConfigurationMapper.fromSystemConfiguration((DroneConfiguration)this, qualifier);
    }

    public String getConfigurationName() {
        return CONFIGURATION_NAME;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Deprecated
    public String getOutput() {
        return this.logFile;
    }

    @Deprecated
    public void setOutput(String output) {
        this.logFile = output;
    }

    @Deprecated
    public boolean isEnable() {
        return !this.skip;
    }

    @Deprecated
    public void setEnable(boolean enable) {
        this.skip = !enable;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public boolean isAvoidProxy() {
        return this.avoidProxy;
    }

    public void setAvoidProxy(boolean avoidProxy) {
        this.avoidProxy = avoidProxy;
    }

    public boolean isBrowserSessionReuse() {
        return this.browserSessionReuse;
    }

    public void setBrowserSessionReuse(boolean browserSessionReuse) {
        this.browserSessionReuse = browserSessionReuse;
    }

    public boolean isBrowserSideLog() {
        return this.browserSideLog;
    }

    public void setBrowserSideLog(boolean browserSideLog) {
        this.browserSideLog = browserSideLog;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDontTouchLogging(boolean dontTouchLogging) {
        this.dontTouchLogging = dontTouchLogging;
    }

    public boolean isDontTouchLogging() {
        return this.dontTouchLogging;
    }

    public boolean isEnsureCleanSession() {
        return this.ensureCleanSession;
    }

    public void setEnsureCleanSession(boolean ensureCleanSession) {
        this.ensureCleanSession = ensureCleanSession;
    }

    public String getFirefoxProfileTemplate() {
        return this.firefoxProfileTemplate;
    }

    public void setFirefoxProfileTemplate(String firefoxProfileTemplate) {
        this.firefoxProfileTemplate = firefoxProfileTemplate;
    }

    public String getForcedBrowserMode() {
        return this.forcedBrowserMode;
    }

    public void setForcedBrowserMode(String forcedBrowserMode) {
        this.forcedBrowserMode = forcedBrowserMode;
    }

    public void setHonorSystemProxy(boolean honorSystemProxy) {
        this.honorSystemProxy = honorSystemProxy;
    }

    public boolean isHonorSystemProxy() {
        return this.honorSystemProxy;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getProfilesLocation() {
        return this.profilesLocation;
    }

    public void setProfilesLocation(String profilesLocation) {
        this.profilesLocation = profilesLocation;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyInjectionMode(boolean proxyInjectionMode) {
        this.proxyInjectionMode = proxyInjectionMode;
    }

    public boolean isProxyInjectionMode() {
        return this.proxyInjectionMode;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setRetryTimeoutInSeconds(int retryTimeoutInSeconds) {
        this.retryTimeoutInSeconds = retryTimeoutInSeconds;
    }

    public int getRetryTimeoutInSeconds() {
        return this.retryTimeoutInSeconds;
    }

    public boolean isSingleWindow() {
        return this.singleWindow;
    }

    public void setSingleWindow(boolean singleWindow) {
        this.singleWindow = singleWindow;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setSystemProperties(String systemProperties) {
        this.systemProperties = systemProperties;
    }

    public String getSystemProperties() {
        return this.systemProperties;
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public boolean isTrustAllSSLCertificates() {
        return this.trustAllSSLCertificates;
    }

    public void setTrustAllSSLCertificates(boolean trustAllSSLCertificates) {
        this.trustAllSSLCertificates = trustAllSSLCertificates;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getUserExtensions() {
        return this.userExtensions;
    }

    public void setUserExtensions(String userExtensions) {
        this.userExtensions = userExtensions;
    }
}

