/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.selenium.server.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.arquillian.drone.selenium.server.configuration.SeleniumServerConfiguration;
import org.jboss.arquillian.drone.selenium.server.impl.SecurityActions;
import org.jboss.arquillian.drone.selenium.server.impl.Validate;

public class SystemEnvHolder {
    private String proxyHost = SecurityActions.getProperty("http.proxyHost");
    private String proxyPort = SecurityActions.getProperty("http.proxyPort");
    private String nonProxyHosts = SecurityActions.getProperty("http.nonProxyHosts");
    private String truststore = SecurityActions.getProperty("javax.net.ssl.trustStore");
    private String truststorePass = SecurityActions.getProperty("javax.net.ssl.trustStorePassword");

    public void modifyEnvBy(SeleniumServerConfiguration configuration) {
        String systemProperties;
        String trustStorePass;
        String trustStore;
        String nonProxyHosts;
        String proxyPort;
        String proxyHost = configuration.getProxyHost();
        if (proxyHost != null) {
            SecurityActions.setProperty("http.proxyHost", proxyHost);
        }
        if ((proxyPort = configuration.getProxyPort()) != null) {
            SecurityActions.setProperty("http.proxyPort", proxyPort);
        }
        if ((nonProxyHosts = configuration.getNonProxyHosts()) != null) {
            SecurityActions.setProperty("http.nonProxyHosts", nonProxyHosts);
        }
        if (Validate.isNotNullOrEmpty(trustStore = configuration.getTrustStore())) {
            Validate.isValidFile(trustStore, "Truststore file must exist: " + trustStore);
            SecurityActions.setProperty("javax.net.ssl.trustStore", trustStore);
        }
        if ((trustStorePass = configuration.getTrustStorePassword()) != null) {
            SecurityActions.setProperty("javax.net.ssl.trustStorePassword", trustStorePass);
        }
        if ((systemProperties = configuration.getSystemProperties()) != null) {
            for (String systemProperty : this.getSystemProperties(systemProperties)) {
                String property = systemProperty.replaceFirst("-D", "").replaceFirst("=.*", "");
                String value = systemProperty.replaceFirst("[^=]*=", "");
                SecurityActions.setProperty(property, value);
            }
        }
    }

    private List<String> getSystemProperties(String valueString) {
        ArrayList<String> properties = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(valueString, " ");
        while (tokenizer.hasMoreTokens()) {
            String property = tokenizer.nextToken().trim();
            if (property.indexOf(61) == -1) continue;
            properties.add(property);
        }
        return properties;
    }

    public void restore() {
        SecurityActions.setProperty("http.proxyHost", this.proxyHost);
        SecurityActions.setProperty("http.proxyPort", this.proxyPort);
        SecurityActions.setProperty("http.nonProxyHosts", this.nonProxyHosts);
        SecurityActions.setProperty("javax.net.ssl.trustStore", this.truststore);
        SecurityActions.setProperty("javax.net.ssl.trustStorePassword", this.truststorePass);
    }
}

