/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.spi.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DronePoint;
import org.jboss.arquillian.drone.spi.DronePointFilter;
import org.jboss.arquillian.drone.spi.deployment.DeploymentNameKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentFilter
implements DronePointFilter<Object> {
    private final Pattern pattern;

    public DeploymentFilter() {
        this(".*");
    }

    public DeploymentFilter(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean accepts(DroneContext context, DronePoint<?> dronePoint) {
        String deploymentName = (String)context.get(dronePoint).getMetadata(DeploymentNameKey.class);
        if (deploymentName == null) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(deploymentName);
        return matcher.matches();
    }
}

