/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.guice.impl.client;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.guice.impl.configuration.GuiceExtensionConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceProtocolArchiveProcessor
implements ProtocolArchiveProcessor {
    @Inject
    private Instance<GuiceExtensionConfiguration> configurationInstance;

    public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
        if (((GuiceExtensionConfiguration)this.configurationInstance.get()).isAutoPackage()) {
            if (this.isEnterpriseArchive(testDeployment.getApplicationArchive()) || this.isWebArchive(testDeployment.getApplicationArchive())) {
                this.addGuiceLibraries(testDeployment.getApplicationArchive());
            } else if (this.isEnterpriseArchive(protocolArchive) || this.isWebArchive(protocolArchive)) {
                this.addGuiceLibraries(protocolArchive);
            }
        }
    }

    private boolean isEnterpriseArchive(Archive<?> archive) {
        return archive instanceof EnterpriseArchive;
    }

    private boolean isWebArchive(Archive<?> archive) {
        return archive instanceof WebArchive;
    }

    private void addGuiceLibraries(Archive<?> archive) {
        File[] guiceLibraries = this.resolveGuiceDependencies();
        if (archive instanceof EnterpriseArchive) {
            ((EnterpriseArchive)archive).addAsModules(guiceLibraries);
        } else if (archive instanceof WebArchive) {
            ((WebArchive)archive).addAsLibraries(guiceLibraries);
        }
    }

    private File[] resolveGuiceDependencies() {
        ArrayList<File> dependencies = new ArrayList<File>();
        dependencies.addAll(this.resolveArtifact("com.google.inject:guice", ((GuiceExtensionConfiguration)this.configurationInstance.get()).getGuiceVersion(), "3.0"));
        dependencies.addAll(this.resolveArtifact("com.google.inject.extensions:guice-servlet", ((GuiceExtensionConfiguration)this.configurationInstance.get()).getGuiceVersion(), "3.0"));
        return dependencies.toArray(new File[dependencies.size()]);
    }

    private Collection<File> resolveArtifact(String artifact, String version, String defaultVersion) {
        File[] artifacts = null;
        String artifactVersion = version != null ? version : defaultVersion;
        try {
            artifacts = this.resolveArtifact(artifact);
        }
        catch (Exception e) {
            artifacts = this.resolveArtifact(artifact + ":" + artifactVersion);
        }
        return Arrays.asList(artifacts);
    }

    private File[] resolveArtifact(String artifact) {
        return ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(artifact)).withTransitivity()).asFile();
    }
}

