/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.guice.impl.configuration;

import java.util.Collections;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.guice.impl.configuration.GuiceExtensionConfiguration;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceExtensionConfigurationProducer {
    private static final String GUICE_EXTENSION = "guice";
    private static final String AUTO_PACKAGE_PROPERTY_NAME = "autoPackage";
    private static final String GUICE_VERSION_PROPERTY_NAME = "guiceVersion";
    @Inject
    private Instance<ArquillianDescriptor> descriptor;
    @Inject
    @ApplicationScoped
    private InstanceProducer<GuiceExtensionConfiguration> configurationInstance;

    public void loadConfiguration(@Observes BeforeSuite beforeSuiteEvent) {
        GuiceExtensionConfiguration config = this.getConfiguration((ArquillianDescriptor)this.descriptor.get());
        this.configurationInstance.set((Object)config);
    }

    private GuiceExtensionConfiguration getConfiguration(ArquillianDescriptor arquillianDescriptor) {
        GuiceExtensionConfiguration config = new GuiceExtensionConfiguration();
        Map<String, String> guiceExt = this.getGuiceExtensionSettings((ArquillianDescriptor)this.descriptor.get());
        if (!guiceExt.isEmpty()) {
            if (guiceExt.containsKey(AUTO_PACKAGE_PROPERTY_NAME)) {
                config.setAutoPackage(Boolean.parseBoolean(guiceExt.get(AUTO_PACKAGE_PROPERTY_NAME)));
            }
            config.setGuiceVersion(guiceExt.get(GUICE_VERSION_PROPERTY_NAME));
        }
        return config;
    }

    private Map<String, String> getGuiceExtensionSettings(ArquillianDescriptor arquillianDescriptor) {
        for (ExtensionDef extensionDef : arquillianDescriptor.getExtensions()) {
            if (!GUICE_EXTENSION.equals(extensionDef.getExtensionName())) continue;
            return extensionDef.getExtensionProperties();
        }
        return Collections.emptyMap();
    }
}

