/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.guice.impl.enricher;

import com.google.inject.Injector;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.guice.impl.enricher.SecurityActions;
import org.jboss.arquillian.test.spi.TestEnricher;

public class GuiceInjectionEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(GuiceInjectionEnricher.class.getName());
    @Inject
    private Instance<Injector> injectorInstance;

    public void enrich(Object testCase) {
        if (SecurityActions.isClassPresent("com.google.inject.Injector") && this.isInjectorExists(testCase)) {
            this.injectClass(testCase);
        }
    }

    private boolean isInjectorExists(Object testCase) {
        return this.injectorInstance.get() != null;
    }

    public Object[] resolve(Method method) {
        return new Object[method.getParameterTypes().length];
    }

    private void injectClass(Object testCase) {
        Injector injector = this.getInjectorInstance();
        if (injector != null) {
            injector.injectMembers(testCase);
            log.fine("Injecting dependencies into guice model " + testCase.getClass().getSimpleName());
        }
    }

    private Injector getInjectorInstance() {
        return (Injector)this.injectorInstance.get();
    }
}

