/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.guice.impl.inject;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.guice.api.annotation.GuiceConfiguration;
import org.jboss.arquillian.guice.api.annotation.GuiceInjector;
import org.jboss.arquillian.guice.api.annotation.GuiceWebConfiguration;
import org.jboss.arquillian.guice.api.utils.InjectorHolder;
import org.jboss.arquillian.guice.impl.inject.SecurityActions;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorProducer {
    private static final Logger log = Logger.getLogger(InjectorProducer.class.getName());
    @Inject
    @ApplicationScoped
    private InstanceProducer<Injector> injectorInstance;

    public void initInjector(@Observes BeforeClass beforeClass) {
        TestClass testClass = beforeClass.getTestClass();
        if (this.isGuiceTest(testClass)) {
            Injector injector;
            if (this.hasCustomInjector(testClass)) {
                injector = this.getCustomInjector(testClass);
            } else if (testClass.isAnnotationPresent(GuiceWebConfiguration.class)) {
                injector = this.getServletContextInjector();
            } else {
                injector = this.createInjector(testClass);
                log.fine("Successfully created guice injector for model class: " + testClass.getName());
            }
            if (injector != null) {
                this.injectorInstance.set((Object)injector);
            }
        }
    }

    private Injector createInjector(TestClass testClass) {
        return Guice.createInjector((Module[])this.getTestClassModules(testClass));
    }

    private Injector getServletContextInjector() {
        return InjectorHolder.getInjector();
    }

    private Injector getCustomInjector(TestClass testClass) {
        try {
            List<Method> methods = SecurityActions.getStaticMethodsWithAnnotation(testClass.getJavaClass(), GuiceInjector.class);
            if (methods.size() > 1) {
                throw new RuntimeException("Test case may declare only one custom injector method.");
            }
            return (Injector)methods.get(0).invoke(null, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error occurred when invoking custom injector method.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error occurred when invoking custom injector method.", e);
        }
    }

    private boolean isGuiceTest(TestClass testClass) {
        return testClass.isAnnotationPresent(GuiceConfiguration.class) || testClass.isAnnotationPresent(GuiceWebConfiguration.class) || this.hasCustomInjector(testClass);
    }

    private boolean hasCustomInjector(TestClass testClass) {
        return SecurityActions.getStaticMethodsWithAnnotation(testClass.getJavaClass(), GuiceInjector.class).size() > 0;
    }

    private Module[] getTestClassModules(TestClass testClass) {
        ArrayList modules = new ArrayList();
        GuiceConfiguration guiceConfiguration = (GuiceConfiguration)testClass.getAnnotation(GuiceConfiguration.class);
        Collections.addAll(modules, this.instantiateModules(guiceConfiguration.value()));
        return modules.toArray(new Module[modules.size()]);
    }

    private Module[] instantiateModules(Class<? extends Module>[] classes) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Class<? extends Module> c : classes) {
            modules.add(this.instantiateClass(c));
        }
        return modules.toArray(new Module[modules.size()]);
    }

    private Module instantiateClass(Class<? extends Module> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate Guice module.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not instantiate Guice module.", e);
        }
    }
}

