/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.guice.impl.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityActions {
    private SecurityActions() {
    }

    static List<Method> getStaticMethodsWithAnnotation(final Class<?> source, final Class<? extends Annotation> annotationClass) {
        return AccessController.doPrivileged(new PrivilegedAction<List<Method>>(){

            @Override
            public List<Method> run() {
                ArrayList<Method> foundMethods = new ArrayList<Method>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Method method : nextSource.getDeclaredMethods()) {
                        if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(annotationClass)) continue;
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        foundMethods.add(method);
                    }
                }
                return foundMethods;
            }
        });
    }
}

