/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit;

import java.sql.SQLException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ExcludeTableFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.persistence.CleanupStrategy;
import org.jboss.arquillian.persistence.DataSeedStrategy;
import org.jboss.arquillian.persistence.core.data.DataHandler;
import org.jboss.arquillian.persistence.core.event.CleanupData;
import org.jboss.arquillian.persistence.core.event.CleanupDataUsingScript;
import org.jboss.arquillian.persistence.core.event.ExecuteScripts;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionFeatureResolver;
import org.jboss.arquillian.persistence.core.test.AssertionErrorCollector;
import org.jboss.arquillian.persistence.dbunit.DataSetComparator;
import org.jboss.arquillian.persistence.dbunit.DataSetUtils;
import org.jboss.arquillian.persistence.dbunit.cleanup.CleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.cleanup.CleanupStrategyProvider;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitDataSeedStrategyProvider;
import org.jboss.arquillian.persistence.dbunit.dataset.DataSetRegister;
import org.jboss.arquillian.persistence.dbunit.event.CompareDBUnitData;
import org.jboss.arquillian.persistence.dbunit.event.PrepareDBUnitData;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitConnectionException;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitDataSetHandlingException;
import org.jboss.arquillian.persistence.dbunit.filter.TableFilterResolver;
import org.jboss.arquillian.persistence.script.ScriptExecutor;
import org.jboss.arquillian.persistence.script.configuration.ScriptingConfiguration;
import org.jboss.arquillian.persistence.script.data.descriptor.SqlScriptResourceDescriptor;
import org.jboss.arquillian.persistence.script.splitter.StatementSplitterResolver;
import org.jboss.arquillian.persistence.spi.dbunit.filter.TableFilterProvider;
import org.jboss.arquillian.persistence.spi.script.StatementSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUnitDataHandler
implements DataHandler<PrepareDBUnitData, CompareDBUnitData> {
    @Inject
    private Instance<DatabaseConnection> databaseConnection;
    @Inject
    private Instance<DataSetRegister> dataSetRegister;
    @Inject
    private Instance<AssertionErrorCollector> assertionErrorCollector;
    @Inject
    private Instance<DBUnitConfiguration> dbunitConfigurationInstance;
    @Inject
    private Instance<ScriptingConfiguration> scriptConfigurationInstance;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverInstance;

    public void prepare(@Observes PrepareDBUnitData prepareDataEvent) {
        try {
            this.seedDatabase();
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Failed while seeding database.", e);
        }
    }

    public void compare(@Observes CompareDBUnitData compareDataEvent) {
        try {
            IDataSet currentDataSet = ((DatabaseConnection)this.databaseConnection.get()).createDataSet();
            String[] excludeTables = ((DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())).getExcludeTablesFromComparisonWhenEmptyExpected();
            if (excludeTables.length != 0) {
                currentDataSet = new FilteredDataSet((ITableFilter)new ExcludeTableFilter(excludeTables), currentDataSet);
            }
            IDataSet expectedDataSet = DataSetUtils.mergeDataSets(((DataSetRegister)this.dataSetRegister.get()).getExpected());
            DataSetComparator dataSetComparator = new DataSetComparator(compareDataEvent.getSortByColumns(), compareDataEvent.getColumnsToExclude(), compareDataEvent.getCustomColumnFilters());
            dataSetComparator.compare(currentDataSet, expectedDataSet, (AssertionErrorCollector)this.assertionErrorCollector.get());
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Failed while comparing database state with provided data sets.", e);
        }
    }

    public void cleanup(@Observes CleanupData cleanupDataEvent) {
        this.cleanDatabase(cleanupDataEvent.cleanupStrategy);
    }

    public void cleanupUsingScript(@Observes CleanupDataUsingScript cleanupDataUsingScriptEvent) {
        for (SqlScriptResourceDescriptor scriptDescriptor : cleanupDataUsingScriptEvent.getDescriptors()) {
            String script = (String)scriptDescriptor.getContent();
            this.executeScript(script);
        }
    }

    public void executeScripts(@Observes ExecuteScripts executeScriptsEvent) {
        for (SqlScriptResourceDescriptor scriptDescriptor : executeScriptsEvent.getDescriptors()) {
            String script = (String)scriptDescriptor.getContent();
            this.executeScript(script);
        }
    }

    private void executeScript(String script) {
        try {
            StatementSplitter statementSplitter = new StatementSplitterResolver((ScriptingConfiguration)this.scriptConfigurationInstance.get()).resolve();
            ScriptExecutor scriptExecutor = new ScriptExecutor(((DatabaseConnection)this.databaseConnection.get()).getConnection(), (ScriptingConfiguration)this.scriptConfigurationInstance.get(), statementSplitter);
            scriptExecutor.execute(script);
        }
        catch (SQLException e) {
            throw new DBUnitConnectionException("Unable to execute script.", e);
        }
    }

    private void seedDatabase() throws Exception {
        DatabaseConnection connection = (DatabaseConnection)this.databaseConnection.get();
        IDataSet initialDataSet = DataSetUtils.mergeDataSets(((DataSetRegister)this.dataSetRegister.get()).getInitial());
        if (((DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())).isFilterTables()) {
            TableFilterProvider sequenceFilterProvider = new TableFilterResolver((DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())).resolve();
            ITableFilter databaseSequenceFilter = sequenceFilterProvider.provide((IDatabaseConnection)connection, initialDataSet.getTableNames());
            initialDataSet = new FilteredDataSet(databaseSequenceFilter, initialDataSet);
        }
        this.seedingStrategy().execute((IDatabaseConnection)connection, initialDataSet);
    }

    private DatabaseOperation seedingStrategy() {
        DBUnitConfiguration dbUnitConfiguration = (DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get());
        DataSeedStrategy dataSeedStrategy = ((PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get()).getDataSeedStrategy();
        boolean useIdentityInsert = dbUnitConfiguration.isUseIdentityInsert();
        return (DatabaseOperation)dataSeedStrategy.provide((DataSeedStrategy.StrategyProvider)new DBUnitDataSeedStrategyProvider(useIdentityInsert));
    }

    private void cleanDatabase(CleanupStrategy cleanupStrategy) {
        CleanupStrategyExecutor cleanupStrategyExecutor = (CleanupStrategyExecutor)cleanupStrategy.provide((CleanupStrategy.StrategyProvider)new CleanupStrategyProvider((DatabaseConnection)this.databaseConnection.get(), (DataSetRegister)this.dataSetRegister.get(), (DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())));
        cleanupStrategyExecutor.cleanupDatabase(((DBUnitConfiguration)((Object)this.dbunitConfigurationInstance.get())).getExcludeTablesFromCleanup());
    }
}

