/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.cleanup;

import java.util.logging.Logger;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.arquillian.persistence.dbunit.DataSetUtils;
import org.jboss.arquillian.persistence.dbunit.cleanup.CleanupStrategyExecutor;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.dataset.DataSetRegister;
import org.jboss.arquillian.persistence.dbunit.exception.DBUnitDataSetHandlingException;
import org.jboss.arquillian.persistence.dbunit.filter.TableFilterResolver;
import org.jboss.arquillian.persistence.spi.dbunit.filter.TableFilterProvider;

public class SeededDataOnlyCleanupStrategyExecutor
implements CleanupStrategyExecutor {
    private static final Logger LOG = Logger.getLogger(SeededDataOnlyCleanupStrategyExecutor.class.getName());
    private final DatabaseConnection connection;
    private final DataSetRegister dataSetRegister;
    private final DBUnitConfiguration dbUnitConfiguration;

    public SeededDataOnlyCleanupStrategyExecutor(DatabaseConnection connection, DataSetRegister dataSetRegister, DBUnitConfiguration dbUnitConfiguration) {
        this.connection = connection;
        this.dataSetRegister = dataSetRegister;
        this.dbUnitConfiguration = dbUnitConfiguration;
    }

    public void cleanupDatabase(String ... tablesToExclude) {
        if (this.dataSetRegister.getInitial() == null || this.dataSetRegister.getInitial().isEmpty()) {
            LOG.warning("Attempted to cleanup database using USED_ROWS strategy, but no data sets were used.");
            return;
        }
        try {
            IDataSet mergeDataSets = DataSetUtils.mergeDataSets(this.dataSetRegister.getInitial());
            IDataSet dataSet = DataSetUtils.excludeTables(mergeDataSets, tablesToExclude);
            if (this.dbUnitConfiguration.isFilterTables()) {
                TableFilterProvider sequenceFilterProvider = new TableFilterResolver(this.dbUnitConfiguration).resolve();
                ITableFilter tableFilter = sequenceFilterProvider.provide((IDatabaseConnection)this.connection, dataSet.getTableNames());
                dataSet = new FilteredDataSet(tableFilter, dataSet);
            }
            DatabaseOperation.DELETE.execute((IDatabaseConnection)this.connection, dataSet);
        }
        catch (Exception e) {
            throw new DBUnitDataSetHandlingException("Unable to clean database.", e);
        }
    }
}

