/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.filter;

import java.util.Collection;
import java.util.logging.Logger;
import org.jboss.arquillian.persistence.core.util.Strings;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.filter.DefaultDatabaseSequenceFilterProvider;
import org.jboss.arquillian.persistence.spi.dbunit.filter.TableFilterProvider;
import org.jboss.arquillian.persistence.util.JavaSPIExtensionLoader;

public class TableFilterResolver {
    private static final Logger log = Logger.getLogger(TableFilterResolver.class.getName());
    private final DBUnitConfiguration dbUnitConfiguration;

    public TableFilterResolver(DBUnitConfiguration dbUnitConfiguration) {
        this.dbUnitConfiguration = dbUnitConfiguration;
    }

    public TableFilterProvider resolve() {
        if (Strings.isEmpty((String)this.dbUnitConfiguration.getCustomTableFilter())) {
            return new DefaultDatabaseSequenceFilterProvider();
        }
        TableFilterProvider resolved = null;
        Collection databaseSequenceFilterProviders = new JavaSPIExtensionLoader().all(Thread.currentThread().getContextClassLoader(), TableFilterProvider.class);
        for (TableFilterProvider databaseSequenceFilterProvider : databaseSequenceFilterProviders) {
            if (!databaseSequenceFilterProvider.getClass().getName().equals(this.dbUnitConfiguration.getCustomTableFilter())) continue;
            resolved = databaseSequenceFilterProvider;
        }
        if (resolved == null) {
            log.warning("Unable to find sequence filter for " + this.dbUnitConfiguration.getCustomTableFilter() + ". Using default database sequence filter.");
            return new DefaultDatabaseSequenceFilterProvider();
        }
        return resolved;
    }
}

