/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.persistence.dbunit.lifecycle;

import java.lang.reflect.Method;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.persistence.ShouldMatchDataSet;
import org.jboss.arquillian.persistence.core.event.AfterPersistenceTest;
import org.jboss.arquillian.persistence.core.event.BeforePersistenceTest;
import org.jboss.arquillian.persistence.core.metadata.MetadataExtractor;
import org.jboss.arquillian.persistence.core.metadata.PersistenceExtensionFeatureResolver;
import org.jboss.arquillian.persistence.dbunit.api.CustomColumnFilter;
import org.jboss.arquillian.persistence.dbunit.configuration.DBUnitConfiguration;
import org.jboss.arquillian.persistence.dbunit.data.provider.DataSetProvider;
import org.jboss.arquillian.persistence.dbunit.data.provider.ExpectedDataSetProvider;
import org.jboss.arquillian.persistence.dbunit.event.CompareDBUnitData;
import org.jboss.arquillian.persistence.dbunit.event.PrepareDBUnitData;

public class DataSetHandler {
    @Inject
    private Instance<MetadataExtractor> metadataExtractorInstance;
    @Inject
    private Instance<DBUnitConfiguration> configurationInstance;
    @Inject
    private Instance<PersistenceExtensionFeatureResolver> persistenceExtensionFeatureResolverInstance;
    @Inject
    private Event<PrepareDBUnitData> prepareDataEvent;
    @Inject
    private Event<CompareDBUnitData> compareDataEvent;

    public void prepareDatabase(@Observes(precedence=20) BeforePersistenceTest beforePersistenceTest) {
        PersistenceExtensionFeatureResolver persistenceExtensionFeatureResolver = (PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get();
        if (persistenceExtensionFeatureResolver.shouldSeedData()) {
            DataSetProvider dataSetProvider = new DataSetProvider((MetadataExtractor)this.metadataExtractorInstance.get(), (DBUnitConfiguration)((Object)this.configurationInstance.get()));
            this.prepareDataEvent.fire((Object)new PrepareDBUnitData(dataSetProvider.getDescriptorsDefinedFor(beforePersistenceTest.getTestMethod())));
        }
    }

    public void verifyDatabase(@Observes(precedence=30) AfterPersistenceTest afterPersistenceTest) {
        PersistenceExtensionFeatureResolver persistenceExtensionFeatureResolver = (PersistenceExtensionFeatureResolver)this.persistenceExtensionFeatureResolverInstance.get();
        if (persistenceExtensionFeatureResolver.shouldVerifyDataAfterTest()) {
            MetadataExtractor metadataExtractor = (MetadataExtractor)this.metadataExtractorInstance.get();
            ExpectedDataSetProvider dataSetProvider = new ExpectedDataSetProvider(metadataExtractor, (DBUnitConfiguration)((Object)this.configurationInstance.get()));
            Method testMethod = afterPersistenceTest.getTestMethod();
            ShouldMatchDataSet dataSetsToVerify = (ShouldMatchDataSet)metadataExtractor.shouldMatchDataSet().fetchFrom(testMethod);
            CustomColumnFilter customColumnFilter = (CustomColumnFilter)metadataExtractor.using(CustomColumnFilter.class).fetchFrom(testMethod);
            CompareDBUnitData compareDBUnitDataEvent = new CompareDBUnitData(dataSetProvider.getDescriptorsDefinedFor(testMethod), dataSetsToVerify.orderBy(), dataSetsToVerify.excludeColumns());
            if (customColumnFilter != null) {
                compareDBUnitDataEvent.add(customColumnFilter.value());
            }
            this.compareDataEvent.fire((Object)compareDBUnitDataEvent);
        }
    }
}

