/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.persistence.client;

import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.spring.persistence.client.SpringPersistenceArchiveAppender;
import org.jboss.arquillian.spring.persistence.container.SpringPersistenceRemoteExtension;
import org.jboss.arquillian.spring.persistence.datasource.ApplicationContextDataSourceProvider;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SpringPersistenceArchiveAppenderTestCase {
    private SpringPersistenceArchiveAppender instance;
    private static final List<Class<?>> REQUIRED_CLASSES = Arrays.asList(ApplicationContextDataSourceProvider.class, SpringPersistenceRemoteExtension.class);

    @Before
    public void setUp() {
        this.instance = new SpringPersistenceArchiveAppender();
    }

    @Test
    public void testCreateAuxiliaryArchive() throws Exception {
        Archive archive = this.instance.createAuxiliaryArchive();
        Assert.assertNotNull((String)"Method returned null.", (Object)archive);
        Assert.assertTrue((String)"The returned archive has incorrect type.", (boolean)(archive instanceof JavaArchive));
        for (Class<?> c : REQUIRED_CLASSES) {
            Assert.assertTrue((String)("The required type is missing: " + c.getName()), (boolean)archive.contains(SpringPersistenceArchiveAppenderTestCase.getClassResourcePath(c)));
        }
    }

    public static ArchivePath getClassResourcePath(Class c) {
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(c.getName().replace(".", "/"));
        sb.append(".class");
        return ArchivePaths.create((String)sb.toString());
    }
}

