/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.persistence.datasource;

import java.util.List;
import javax.sql.DataSource;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.spring.integration.context.RemoteTestScopeApplicationContext;
import org.jboss.arquillian.spring.persistence.datasource.ApplicationContextDataSourceProvider;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.test.AbstractTestTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;

@RunWith(value=MockitoJUnitRunner.class)
public class ApplicationContextDataSourceProviderTestCase
extends AbstractTestTestBase {
    private static final String DATA_SOURCE_NAME = "dataSource";
    @Mock
    private DataSource dataSource;
    @Mock
    private ApplicationContext applicationContext;
    private ApplicationContextDataSourceProvider applicationContextDataSourceProvider;

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(ApplicationContextDataSourceProvider.class);
    }

    @Before
    public void setUp() throws Exception {
        this.applicationContextDataSourceProvider = new ApplicationContextDataSourceProvider();
        this.bind(ApplicationScoped.class, RemoteTestScopeApplicationContext.class, new RemoteTestScopeApplicationContext(this.applicationContext, new TestClass(((Object)((Object)this)).getClass()), false));
        this.getManager().inject((Object)this.applicationContextDataSourceProvider);
    }

    @Test
    public void shouldLookupDataSource() {
        Mockito.when((Object)this.applicationContext.getBean((String)Matchers.eq((Object)DATA_SOURCE_NAME), (Class)Matchers.eq(DataSource.class))).thenReturn((Object)this.dataSource);
        DataSource result = this.applicationContextDataSourceProvider.lookupDataSource(DATA_SOURCE_NAME);
        Assert.assertNotNull((String)"The returned data source was null.", (Object)result);
        Assert.assertEquals((String)"The returned data source was incorrect.", (Object)result, (Object)this.dataSource);
    }

    @Test
    public void shouldLookupNullDataSource() {
        Mockito.when((Object)this.applicationContext.getBean((String)Matchers.any(String.class), (Class)Matchers.any(Class.class))).thenReturn(null);
        DataSource result = this.applicationContextDataSourceProvider.lookupDataSource("not existing data source");
        Assert.assertNull((String)"The returned data source was null.", (Object)result);
    }
}

