/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.rest.warp.impl.resteasy.integration;

import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.jboss.arquillian.extension.rest.warp.impl.resteasy.integration.ResteasyContextBuilder;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.MessageBodyReaderContext;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

@Provider
@ServerInterceptor
public class WarpResteasyInterceptor
implements PreProcessInterceptor,
PostProcessInterceptor,
MessageBodyReaderInterceptor,
MessageBodyWriterInterceptor {
    private static final ThreadLocal<HttpRequest> request = new ThreadLocal();
    private static final ThreadLocal<SecurityContext> securityContext = new ThreadLocal();

    @Context
    public void setSecurityContext(SecurityContext securityContext) {
        WarpResteasyInterceptor.securityContext.set(securityContext);
    }

    public ServerResponse preProcess(HttpRequest httpRequest, ResourceMethod resourceMethod) throws Failure, WebApplicationException {
        request.set(httpRequest);
        ResteasyContextBuilder.buildContext(request.get()).setSecurityContext(securityContext.get()).build();
        return null;
    }

    public Object read(MessageBodyReaderContext context) throws IOException, WebApplicationException {
        Object result = context.proceed();
        ResteasyContextBuilder.buildContext(request.get()).setRequestEntity(result).build();
        return result;
    }

    public void postProcess(ServerResponse serverResponse) {
        ResteasyContextBuilder.buildContext(request.get()).setServerResponse(serverResponse).setSecurityContext(securityContext.get()).build();
    }

    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        context.proceed();
        ResteasyContextBuilder.buildContext(request.get()).setResponseMediaType(context.getMediaType()).build();
    }
}

