/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.client;

import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.spring.SpringExtensionConstants;
import org.jboss.arquillian.spring.client.Spring3EnricherArchiveAppender;
import org.jboss.arquillian.spring.configuration.SpringExtensionConfiguration;
import org.jboss.arquillian.spring.configuration.SpringExtensionRemoteConfiguration;
import org.jboss.arquillian.spring.configuration.SpringExtensionRemoteConfigurationUtils;
import org.jboss.arquillian.spring.container.SecurityActions;
import org.jboss.arquillian.spring.container.Spring3EnricherRemoteExtension;
import org.jboss.arquillian.spring.container.SpringExtensionRemoteConfigurationProducer;
import org.jboss.arquillian.spring.container.SpringInjectionEnricher;
import org.jboss.arquillian.spring.context.AbstractApplicationContextProducer;
import org.jboss.arquillian.spring.context.AnnotatedApplicationContextProducer;
import org.jboss.arquillian.spring.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.context.WebApplicationContextProducer;
import org.jboss.arquillian.spring.context.XmlApplicationContextProducer;
import org.jboss.arquillian.spring.test.annotation.SpringAnnotatedConfiguration;
import org.jboss.arquillian.spring.test.annotation.SpringConfiguration;
import org.jboss.arquillian.spring.test.annotation.SpringWebConfiguration;
import org.jboss.arquillian.spring.utils.TestReflectionHelper;
import org.jboss.arquillian.spring.utils.TestResourceHelper;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class Spring3EnricherArchiveAppenderTestCase {
    private Spring3EnricherArchiveAppender instance;
    private List<Class<?>> REQUIRED_CLASSES = Arrays.asList(SpringConfiguration.class, SpringWebConfiguration.class, SpringAnnotatedConfiguration.class, XmlApplicationContextProducer.class, AnnotatedApplicationContextProducer.class, WebApplicationContextProducer.class, AbstractApplicationContextProducer.class, TestScopeApplicationContext.class, SpringInjectionEnricher.class, SecurityActions.class, SpringExtensionRemoteConfigurationProducer.class, SpringExtensionRemoteConfiguration.class, SpringExtensionRemoteConfigurationUtils.class, Spring3EnricherRemoteExtension.class, SpringExtensionConstants.class);

    @Before
    public void setUp() {
        this.instance = new Spring3EnricherArchiveAppender();
    }

    @Test
    public void testBuildArchive() throws Exception {
        SpringExtensionConfiguration extensionConfiguration = new SpringExtensionConfiguration();
        Instance mockExtensionConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockExtensionConfigurationInstance.get()).thenReturn((Object)extensionConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "configuration", mockExtensionConfigurationInstance);
        Archive archive = this.instance.buildArchive();
        Assert.assertNotNull((String)"Method returned null.", (Object)archive);
        Assert.assertTrue((String)"The returned archive has incorrect type.", (boolean)(archive instanceof JavaArchive));
        for (Class<?> c : this.REQUIRED_CLASSES) {
            Assert.assertTrue((String)("The required type is missing: " + c.getName()), (boolean)archive.contains(TestResourceHelper.getClassResourcePath(c)));
        }
    }
}

