/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.context;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.spring.configuration.SpringExtensionRemoteConfiguration;
import org.jboss.arquillian.spring.context.AnnotatedApplicationContextProducer;
import org.jboss.arquillian.spring.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.model.AnnotatedClassesCustomContextClass;
import org.jboss.arquillian.spring.model.AnnotatedPackagesCustomContextClass;
import org.jboss.arquillian.spring.model.ClassesAnnotatedClass;
import org.jboss.arquillian.spring.model.NoConfigAnnotatedClass;
import org.jboss.arquillian.spring.model.PackagesAnnotatedClass;
import org.jboss.arquillian.spring.model.PlainClass;
import org.jboss.arquillian.spring.utils.TestReflectionHelper;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class AnnotatedApplicationContextProducerTestCase {
    private AnnotatedApplicationContextProducer instance;
    private SpringExtensionRemoteConfiguration extensionRemoteConfiguration;

    @Before
    public void setUp() throws Exception {
        this.instance = new AnnotatedApplicationContextProducer();
        this.extensionRemoteConfiguration = new SpringExtensionRemoteConfiguration();
        Instance mockExtensionRemoteConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockExtensionRemoteConfigurationInstance.get()).thenReturn((Object)this.extensionRemoteConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "remoteConfiguration", mockExtensionRemoteConfigurationInstance);
    }

    @Test
    public void testSupportsFalse() {
        TestClass testClass = new TestClass(PlainClass.class);
        Assert.assertFalse((String)"Class without annotations shouldn't be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue1() {
        TestClass testClass = new TestClass(ClassesAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue2() {
        TestClass testClass = new TestClass(PackagesAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testCreateApplicationContextCustomContextClassesConfiguration() {
        TestClass testClass = new TestClass(ClassesAnnotatedClass.class);
        this.extensionRemoteConfiguration.setCustomAnnotationContextClass("org.springframework.context.annotation.AnnotationConfigApplicationContext");
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextClassesConfigurationError() {
        TestClass testClass = new TestClass(ClassesAnnotatedClass.class);
        this.extensionRemoteConfiguration.setCustomAnnotationContextClass("invalid class name");
        this.instance.createApplicationContext(testClass);
    }

    @Test
    public void testCreateApplicationContextCustomContextPackagesConfiguration() {
        TestClass testClass = new TestClass(PackagesAnnotatedClass.class);
        this.extensionRemoteConfiguration.setCustomAnnotationContextClass("org.springframework.context.annotation.AnnotationConfigApplicationContext");
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextPackagesConfigurationError() {
        TestClass testClass = new TestClass(PackagesAnnotatedClass.class);
        this.extensionRemoteConfiguration.setCustomAnnotationContextClass("invalid class name");
        this.instance.createApplicationContext(testClass);
    }

    @Test
    public void testCreateApplicationContextCustomContextClasses() {
        TestClass testClass = new TestClass(AnnotatedClassesCustomContextClass.class);
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextClassesConfigurationAndAnnotation() {
        TestClass testClass = new TestClass(AnnotatedClassesCustomContextClass.class);
        this.extensionRemoteConfiguration.setCustomAnnotationContextClass("invalid class name");
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test
    public void testCreateApplicationContextCustomContextPackages() {
        TestClass testClass = new TestClass(AnnotatedPackagesCustomContextClass.class);
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextPackagesConfigurationAndAnnotation() {
        TestClass testClass = new TestClass(AnnotatedPackagesCustomContextClass.class);
        this.extensionRemoteConfiguration.setCustomAnnotationContextClass("invalid class name");
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextError() {
        TestClass testClass = new TestClass(NoConfigAnnotatedClass.class);
        this.instance.createApplicationContext(testClass);
    }

    @Test
    public void testInitApplicationContextNotSupported() throws Exception {
        BeforeClass event = new BeforeClass(PlainClass.class);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockProducer);
        this.instance.initApplicationContext(event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockProducer});
    }

    @Test
    public void testInitApplicationContextDefault() throws Exception {
        BeforeClass event = new BeforeClass(ClassesAnnotatedClass.class);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockProducer);
        this.instance.initApplicationContext(event);
        ArgumentCaptor argument = ArgumentCaptor.forClass(TestScopeApplicationContext.class);
        ((InstanceProducer)Mockito.verify((Object)mockProducer)).set(argument.capture());
        Assert.assertNotNull((String)"The result was null.", (Object)argument.getValue());
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)((TestScopeApplicationContext)argument.getValue()).isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)((TestScopeApplicationContext)argument.getValue()).getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testInitApplicationContextMissingResource() throws Exception {
        BeforeClass event = new BeforeClass(NoConfigAnnotatedClass.class);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockProducer);
        this.instance.initApplicationContext(event);
    }
}

