/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.dependency;

import java.io.File;
import org.jboss.arquillian.spring.configuration.SpringExtensionConfiguration;
import org.jboss.arquillian.spring.dependency.Spring3DependencyResolver;
import org.junit.Assert;
import org.junit.Test;

public class Spring3DependencyResolverTestCase {
    private Spring3DependencyResolver instance;

    @Test
    public void testResolveDependencies() {
        SpringExtensionConfiguration springExtensionConfiguration = this.createConfiguration();
        springExtensionConfiguration.setIncludeSnowdrop(false);
        this.instance = new Spring3DependencyResolver(springExtensionConfiguration);
        File[] files = this.instance.resolveDependencies();
        this.assertDependencies(files, true, true, true, false);
    }

    @Test
    public void testResolveDependenciesIncludeSnowdrop() {
        SpringExtensionConfiguration springExtensionConfiguration = this.createConfiguration();
        this.instance = new Spring3DependencyResolver(springExtensionConfiguration);
        File[] files = this.instance.resolveDependencies();
        this.assertDependencies(files, true, true, true, true);
    }

    private void assertDependencies(File[] files, boolean springPresentExpected, boolean springWebPresentExpected, boolean cglibPresentExpected, boolean snowdropPresentExpected) {
        boolean isSpringPresent = false;
        boolean isSpringWebPresent = false;
        boolean isCglibPresent = false;
        boolean isSnowdropPresent = false;
        for (File file : files) {
            String path = file.getAbsolutePath();
            if (path.contains("spring-context")) {
                isSpringPresent = true;
                continue;
            }
            if (path.contains("spring-web")) {
                isSpringWebPresent = true;
                continue;
            }
            if (path.contains("cglib")) {
                isCglibPresent = true;
                continue;
            }
            if (!path.contains("snowdrop-vfs")) continue;
            isSnowdropPresent = true;
        }
        Assert.assertEquals((String)"Required dependencies is missing: spring-context.", (Object)springPresentExpected, (Object)isSpringPresent);
        Assert.assertEquals((String)"Required dependencies is missing: spring-web.", (Object)springWebPresentExpected, (Object)isSpringWebPresent);
        Assert.assertEquals((String)"Required dependencies is missing: cglib.", (Object)cglibPresentExpected, (Object)isCglibPresent);
        Assert.assertEquals((String)"Required dependencies is missing: snowdrop.", (Object)snowdropPresentExpected, (Object)isSnowdropPresent);
    }

    private SpringExtensionConfiguration createConfiguration() {
        SpringExtensionConfiguration springExtensionConfiguration = new SpringExtensionConfiguration();
        springExtensionConfiguration.setAutoPackaging(true);
        springExtensionConfiguration.setSpringVersion("3.1.1.RELEASE");
        springExtensionConfiguration.setCglibVersion("2.2.2");
        springExtensionConfiguration.setIncludeSnowdrop(true);
        return springExtensionConfiguration;
    }
}

