/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.deployer.dependency;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.spring.deployer.configuration.SpringDeployerConfiguration;
import org.jboss.arquillian.spring.deployer.dependency.AbstractDependencyResolver;
import org.jboss.arquillian.spring.deployer.dependency.CachedDependencyResolver;
import org.jboss.arquillian.spring.deployer.dependency.Spring3DependencyResolver;
import org.jboss.arquillian.spring.deployer.dependency.Spring3DependencyResolverProducer;
import org.jboss.arquillian.spring.deployer.utils.TestReflectionHelper;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class Spring3DependencyResolverProducerTestCase {
    private Spring3DependencyResolverProducer instance;

    @Before
    public void setUp() {
        this.instance = new Spring3DependencyResolverProducer();
    }

    @Test
    public void testInitDependencyResolver() throws Exception {
        BeforeSuite event = new BeforeSuite();
        SpringDeployerConfiguration configuration = new SpringDeployerConfiguration();
        configuration.setEnableCache(false);
        Instance mockConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockConfigurationInstance.get()).thenReturn((Object)configuration);
        TestReflectionHelper.setFieldValue(this.instance, "configuration", mockConfigurationInstance);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "dependencyResolver", mockProducer);
        this.instance.initDependencyResolver(event);
        ArgumentCaptor dependencyResolver = ArgumentCaptor.forClass(AbstractDependencyResolver.class);
        ((InstanceProducer)Mockito.verify((Object)mockProducer)).set(dependencyResolver.capture());
        Assert.assertNotNull((String)"The crated dependency resolver was null.", (Object)dependencyResolver.getValue());
        Assert.assertTrue((String)"The producer created incorrect type.", (boolean)(dependencyResolver.getValue() instanceof Spring3DependencyResolver));
    }

    @Test
    public void testInitDependencyResolverCached() throws Exception {
        BeforeSuite event = new BeforeSuite();
        SpringDeployerConfiguration configuration = new SpringDeployerConfiguration();
        configuration.setEnableCache(true);
        Instance mockConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockConfigurationInstance.get()).thenReturn((Object)configuration);
        TestReflectionHelper.setFieldValue(this.instance, "configuration", mockConfigurationInstance);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "dependencyResolver", mockProducer);
        this.instance.initDependencyResolver(event);
        ArgumentCaptor dependencyResolver = ArgumentCaptor.forClass(AbstractDependencyResolver.class);
        ((InstanceProducer)Mockito.verify((Object)mockProducer)).set(dependencyResolver.capture());
        Assert.assertNotNull((String)"The crated dependency resolver was null.", (Object)dependencyResolver.getValue());
        Assert.assertTrue((String)"The producer created incorrect type.", (boolean)(dependencyResolver.getValue() instanceof CachedDependencyResolver));
    }
}

