/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.deployer.dependency;

import java.io.File;
import org.jboss.arquillian.spring.deployer.configuration.SpringDeployerConfiguration;
import org.jboss.arquillian.spring.deployer.dependency.Spring3DependencyResolver;
import org.junit.Assert;
import org.junit.Test;

public class Spring3DependencyResolverTestCase {
    private Spring3DependencyResolver instance;

    @Test
    public void testResolveDependencies() {
        SpringDeployerConfiguration springDeployerConfiguration = this.createConfiguration();
        springDeployerConfiguration.setImportPomDependencies(false);
        springDeployerConfiguration.setIncludeSnowdrop(false);
        this.instance = new Spring3DependencyResolver(springDeployerConfiguration);
        File[] files = this.instance.resolveDependencies();
        this.assertDependencies(files, true, true, true, false);
    }

    @Test
    public void testResolveDependenciesOffline() {
        SpringDeployerConfiguration springDeployerConfiguration = this.createConfiguration();
        springDeployerConfiguration.setImportPomDependencies(false);
        springDeployerConfiguration.setIncludeSnowdrop(false);
        springDeployerConfiguration.setUseMavenOffline(true);
        this.instance = new Spring3DependencyResolver(springDeployerConfiguration);
        File[] files = this.instance.resolveDependencies();
        this.assertDependencies(files, true, true, true, false);
    }

    @Test
    public void testResolveDependenciesIncludeSnowdrop() {
        SpringDeployerConfiguration springDeployerConfiguration = this.createConfiguration();
        this.instance = new Spring3DependencyResolver(springDeployerConfiguration);
        File[] files = this.instance.resolveDependencies();
        this.assertDependencies(files, true, true, true, true);
    }

    private void assertDependencies(File[] files, boolean springPresentExpected, boolean springWebPresentExpected, boolean cglibPresentExpected, boolean snowdropPresentExpected) {
        boolean isSpringPresent = false;
        boolean isSpringWebPresent = false;
        boolean isCglibPresent = false;
        boolean isSnowdropPresent = false;
        for (File file : files) {
            String path = file.getAbsolutePath();
            if (path.contains("spring-context")) {
                isSpringPresent = true;
                continue;
            }
            if (path.contains("spring-web")) {
                isSpringWebPresent = true;
                continue;
            }
            if (path.contains("cglib")) {
                isCglibPresent = true;
                continue;
            }
            if (!path.contains("snowdrop-vfs")) continue;
            isSnowdropPresent = true;
        }
        Assert.assertEquals((String)"Required dependencies is missing: spring-context.", (Object)springPresentExpected, (Object)isSpringPresent);
        Assert.assertEquals((String)"Required dependencies is missing: spring-web.", (Object)springWebPresentExpected, (Object)isSpringWebPresent);
        Assert.assertEquals((String)"Required dependencies is missing: cglib.", (Object)cglibPresentExpected, (Object)isCglibPresent);
        Assert.assertEquals((String)"Required dependencies is missing: snowdrop.", (Object)snowdropPresentExpected, (Object)isSnowdropPresent);
    }

    private SpringDeployerConfiguration createConfiguration() {
        SpringDeployerConfiguration springDeployerConfiguration = new SpringDeployerConfiguration();
        springDeployerConfiguration.setAutoPackaging(true);
        springDeployerConfiguration.setSpringVersion("3.1.1.RELEASE");
        springDeployerConfiguration.setCglibVersion("2.2.2");
        springDeployerConfiguration.setIncludeSnowdrop(true);
        return springDeployerConfiguration;
    }
}

