/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.deployer.dependency;

import java.io.File;
import org.jboss.arquillian.spring.deployer.SpringDeployerConstants_3;
import org.jboss.arquillian.spring.deployer.configuration.SpringDeployerConfiguration;
import org.jboss.arquillian.spring.deployer.dependency.AbstractDependencyResolver;
import org.jboss.arquillian.spring.deployer.dependency.MavenDependencyBuilder;

public class Spring3DependencyResolver
extends AbstractDependencyResolver {
    public Spring3DependencyResolver(SpringDeployerConfiguration configuration) {
        super(configuration);
    }

    public File[] resolveDependencies() {
        MavenDependencyBuilder mavenDependencyBuilder = new MavenDependencyBuilder();
        mavenDependencyBuilder.setUseMavenOffline(this.getConfiguration().isUseMavenOffline());
        if (this.getConfiguration().isImportPomDependencies()) {
            mavenDependencyBuilder.importPomDependencies(this.getConfiguration().getPomFile(), this.splitExcludedArtifacts(this.getConfiguration().getExcludedArtifacts()));
        } else {
            for (String artifactId : SpringDeployerConstants_3.SPRING_ARTIFACTS_IDS) {
                mavenDependencyBuilder.addDependency(String.format("%s:%s", "org.springframework", artifactId), this.getArtifactVersion(this.getConfiguration().getSpringVersion(), "3.1.1.RELEASE"), new String[0]);
            }
        }
        mavenDependencyBuilder.addDependency("cglib:cglib", this.getArtifactVersion(this.getConfiguration().getCglibVersion(), "2.2.2"), new String[0]);
        if (this.getConfiguration().isIncludeSnowdrop()) {
            mavenDependencyBuilder.addDependency("org.jboss.snowdrop:snowdrop-vfs", this.getArtifactVersion(this.getConfiguration().getSnowdropVersion(), "2.0.3.Final"), new String[]{"org.springframework:*"});
        }
        return mavenDependencyBuilder.getDependencies();
    }

    private String[] splitExcludedArtifacts(String excludedArtifacts) {
        if (excludedArtifacts == null) {
            return null;
        }
        return excludedArtifacts.split(";");
    }

    private String getArtifactVersion(String artifactVersion, String defaultVersion) {
        return artifactVersion != null ? artifactVersion : defaultVersion;
    }
}

