/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.container;

import java.lang.reflect.Method;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.spring.container.SpringInjectionEnricher;
import org.jboss.arquillian.spring.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.model.StrategyTest;
import org.jboss.arquillian.spring.utils.TestReflectionHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringInjectionEnricherTestCase {
    private SpringInjectionEnricher instance;

    @Before
    public void setUp() {
        this.instance = new SpringInjectionEnricher();
    }

    @Test
    public void testEnrich() throws Exception {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext("testApplicationContext.xml");
        TestScopeApplicationContext testScopeApplicationContext = new TestScopeApplicationContext((ApplicationContext)applicationContext, true);
        Instance mockApplicationContextInstance = (Instance)Mockito.mock(Instance.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockApplicationContextInstance);
        Mockito.when((Object)mockApplicationContextInstance.get()).thenReturn((Object)testScopeApplicationContext);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockApplicationContextInstance);
        StrategyTest strategyTest = new StrategyTest();
        this.instance.enrich((Object)strategyTest);
        Assert.assertNotNull((String)"The bean hasn't been autowired.", (Object)strategyTest.getStrategy());
    }

    @Test
    public void testResolve() throws Exception {
        Class<SpringInjectionEnricherTestCase> clazz = SpringInjectionEnricherTestCase.class;
        Method method = clazz.getMethod("testResolve", null);
        Object[] result = this.instance.resolve(method);
        Assert.assertNotNull((String)"Method returned null result.", (Object)result);
    }
}

