/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.context;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.spring.configuration.SpringExtensionRemoteConfiguration;
import org.jboss.arquillian.spring.context.AbstractApplicationContextProducer;
import org.jboss.arquillian.spring.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.model.PlainClass;
import org.jboss.arquillian.spring.utils.TestReflectionHelper;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.context.ApplicationContext;

public class AbstractApplicationContextProducerTestCase {
    private AbstractApplicationContextProducer instance;

    @Test
    public void testInitApplicationContextNotSupported() throws Exception {
        BeforeClass event = new BeforeClass(PlainClass.class);
        this.instance = (AbstractApplicationContextProducer)Mockito.mock(AbstractApplicationContextProducer.class);
        SpringExtensionRemoteConfiguration extensionRemoteConfiguration = new SpringExtensionRemoteConfiguration();
        Instance mockExtensionRemoteConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockExtensionRemoteConfigurationInstance.get()).thenReturn((Object)extensionRemoteConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "remoteConfiguration", mockExtensionRemoteConfigurationInstance);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockProducer);
        ((AbstractApplicationContextProducer)Mockito.doCallRealMethod().when((Object)this.instance)).initApplicationContext((BeforeClass)Matchers.any(BeforeClass.class));
        Mockito.when((Object)this.instance.supports((TestClass)Matchers.any(TestClass.class))).thenReturn((Object)false);
        this.instance.initApplicationContext(event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockProducer});
    }

    @Test
    public void testInitApplicationContextSupported() throws Exception {
        BeforeClass event = new BeforeClass(PlainClass.class);
        ApplicationContext mockApplicationContext = (ApplicationContext)Mockito.mock(ApplicationContext.class);
        TestScopeApplicationContext testScopeApplicationContext = new TestScopeApplicationContext(mockApplicationContext, false);
        this.instance = (AbstractApplicationContextProducer)Mockito.mock(AbstractApplicationContextProducer.class);
        SpringExtensionRemoteConfiguration extensionRemoteConfiguration = new SpringExtensionRemoteConfiguration();
        Instance mockExtensionRemoteConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockExtensionRemoteConfigurationInstance.get()).thenReturn((Object)extensionRemoteConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "remoteConfiguration", mockExtensionRemoteConfigurationInstance);
        ((AbstractApplicationContextProducer)Mockito.doCallRealMethod().when((Object)this.instance)).initApplicationContext((BeforeClass)Matchers.any(BeforeClass.class));
        Mockito.when((Object)this.instance.supports((TestClass)Matchers.any(TestClass.class))).thenReturn((Object)true);
        Mockito.when((Object)this.instance.createApplicationContext((TestClass)Matchers.any(TestClass.class))).thenReturn((Object)testScopeApplicationContext);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockProducer);
        this.instance.initApplicationContext(event);
        ((InstanceProducer)Mockito.verify((Object)mockProducer)).set((Object)testScopeApplicationContext);
    }
}

