/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.context;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.spring.configuration.SpringExtensionRemoteConfiguration;
import org.jboss.arquillian.spring.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.context.XmlApplicationContextProducer;
import org.jboss.arquillian.spring.model.PlainClass;
import org.jboss.arquillian.spring.model.XmlAnnotatedClass;
import org.jboss.arquillian.spring.model.XmlAnnotatedCustomContextClass;
import org.jboss.arquillian.spring.model.XmlAnnotatedMissingResourceClass;
import org.jboss.arquillian.spring.utils.TestReflectionHelper;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class XmlApplicationContextProducerTestCase {
    private XmlApplicationContextProducer instance;
    private SpringExtensionRemoteConfiguration extensionRemoteConfiguration;

    @Before
    public void setUp() throws Exception {
        this.instance = new XmlApplicationContextProducer();
        this.extensionRemoteConfiguration = new SpringExtensionRemoteConfiguration();
        Instance mockExtensionRemoteConfigurationInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)mockExtensionRemoteConfigurationInstance.get()).thenReturn((Object)this.extensionRemoteConfiguration);
        TestReflectionHelper.setFieldValue(this.instance, "remoteConfiguration", mockExtensionRemoteConfigurationInstance);
    }

    @Test
    public void testSupportsFalse() {
        TestClass testClass = new TestClass(PlainClass.class);
        Assert.assertFalse((String)"Class without annotations shouldn't be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testSupportsTrue() {
        TestClass testClass = new TestClass(XmlAnnotatedClass.class);
        Assert.assertTrue((String)"Class should be supported.", (boolean)this.instance.supports(testClass));
    }

    @Test
    public void testCreateApplicationContextDefault() {
        TestClass testClass = new TestClass(XmlAnnotatedClass.class);
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test
    public void testCreateApplicationContextCustomContextConfiguration() {
        TestClass testClass = new TestClass(XmlAnnotatedClass.class);
        this.extensionRemoteConfiguration.setCustomContextClass("org.springframework.context.support.ClassPathXmlApplicationContext");
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextConfigurationError() {
        TestClass testClass = new TestClass(XmlAnnotatedClass.class);
        this.extensionRemoteConfiguration.setCustomContextClass("invalid class name");
        this.instance.createApplicationContext(testClass);
    }

    @Test
    public void testCreateApplicationContextCustomContext() {
        TestClass testClass = new TestClass(XmlAnnotatedCustomContextClass.class);
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextCustomContextConfigurationAndAnnotation() {
        TestClass testClass = new TestClass(XmlAnnotatedCustomContextClass.class);
        this.extensionRemoteConfiguration.setCustomContextClass("invalid class name");
        TestScopeApplicationContext result = this.instance.createApplicationContext(testClass);
        Assert.assertNotNull((String)"The result was null.", (Object)result);
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)result.isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)result.getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testCreateApplicationContextMissingResource() {
        TestClass testClass = new TestClass(XmlAnnotatedMissingResourceClass.class);
        this.instance.createApplicationContext(testClass);
    }

    @Test
    public void testInitApplicationContextNotSupported() throws Exception {
        BeforeClass event = new BeforeClass(PlainClass.class);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockProducer);
        this.instance.initApplicationContext(event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockProducer});
    }

    @Test
    public void testInitApplicationContextDefault() throws Exception {
        BeforeClass event = new BeforeClass(XmlAnnotatedClass.class);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockProducer);
        this.instance.initApplicationContext(event);
        ArgumentCaptor argument = ArgumentCaptor.forClass(TestScopeApplicationContext.class);
        ((InstanceProducer)Mockito.verify((Object)mockProducer)).set(argument.capture());
        Assert.assertNotNull((String)"The result was null.", (Object)argument.getValue());
        Assert.assertTrue((String)"The application context should be marked as closable.", (boolean)((TestScopeApplicationContext)argument.getValue()).isClosable());
        Assert.assertNotNull((String)"The application context hasn't been created.", (Object)((TestScopeApplicationContext)argument.getValue()).getApplicationContext());
    }

    @Test(expected=RuntimeException.class)
    public void testInitApplicationContextMissingResource() throws Exception {
        BeforeClass event = new BeforeClass(XmlAnnotatedMissingResourceClass.class);
        InstanceProducer mockProducer = (InstanceProducer)Mockito.mock(InstanceProducer.class);
        TestReflectionHelper.setFieldValue(this.instance, "testApplicationContext", mockProducer);
        this.instance.initApplicationContext(event);
    }
}

