/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.deployer.dependency;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jboss.shrinkwrap.resolver.api.DependencyResolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;

public class MavenDependencyBuilder {
    private final Map<String, File> dependenciesMap = new HashMap<String, File>();

    public void addDependency(String artifactName, String artifactVersion, String defaultVersion, String ... exclusions) {
        this.mergeDependencies(this.resolveArtifact(artifactName, artifactVersion, defaultVersion, exclusions));
    }

    public File[] getDependencies() {
        ArrayList<File> result = new ArrayList<File>(this.dependenciesMap.values());
        return result.toArray(new File[result.size()]);
    }

    private void mergeDependencies(File[] files) {
        if (files != null) {
            for (File file : files) {
                this.dependenciesMap.put(file.getAbsolutePath(), file);
            }
        }
    }

    private File[] resolveArtifact(String artifact, String version, String defaultVersion, String ... exclusions) {
        String artifactVersion = version != null && version.length() > 0 ? version : defaultVersion;
        return this.resolveArtifact(artifact, artifactVersion, exclusions);
    }

    private File[] resolveArtifact(String artifact, String version, String ... exclusions) {
        File[] artifacts;
        try {
            artifacts = this.resolveArtifact(artifact, exclusions);
        }
        catch (Exception e) {
            artifacts = this.resolveArtifact(artifact + ":" + version, exclusions);
        }
        return artifacts;
    }

    private File[] resolveArtifact(String artifact, String ... exclusions) {
        MavenDependencyResolver mvnDependencyResolver = (MavenDependencyResolver)DependencyResolvers.use(MavenDependencyResolver.class);
        if (this.isMavenUsed()) {
            mvnDependencyResolver.loadMetadataFromPom("pom.xml");
        }
        return ((MavenDependencyResolver)mvnDependencyResolver.artifacts(new String[]{artifact})).exclusions(exclusions).resolveAsFiles();
    }

    private boolean isMavenUsed() {
        return new File("pom.xml").exists();
    }
}

