/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.testsuite.test;

import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.spring.integration.test.annotation.SpringClientAnnotationConfiguration;
import org.jboss.arquillian.spring.testsuite.beans.model.Employee;
import org.jboss.arquillian.spring.testsuite.beans.repository.EmployeeRepository;
import org.jboss.arquillian.spring.testsuite.beans.repository.impl.DefaultEmployeeRepository;
import org.jboss.arquillian.spring.testsuite.beans.service.EmployeeService;
import org.jboss.arquillian.spring.testsuite.beans.service.impl.DefaultEmployeeService;
import org.jboss.arquillian.spring.testsuite.test.Deployments;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@RunWith(value=Arquillian.class)
@SpringClientAnnotationConfiguration
@RunAsClient
public class AnnotatedClientConfigurationDefaultConfigTestCase {
    @Autowired
    EmployeeService employeeService;

    @Deployment
    public static Archive createTestArchive() {
        return Deployments.createAppDeployment();
    }

    @Test
    public void testGetEmployees() {
        List<Employee> result = this.employeeService.getEmployees();
        Assert.assertNotNull((String)"Method returned null list as result.", result);
        Assert.assertEquals((String)"Two employees were expected.", (long)2L, (long)result.size());
    }

    @Configuration
    public static class DefaultConfiguration {
        @Bean
        public EmployeeRepository defaultEmployeeRepository() {
            return new DefaultEmployeeRepository();
        }

        @Bean
        public EmployeeService defaultEmployeeService() {
            return new DefaultEmployeeService();
        }
    }
}

