/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.testsuite.test;

import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.spring.integration.test.annotation.SpringContextConfiguration;
import org.jboss.arquillian.spring.testsuite.beans.model.Employee;
import org.jboss.arquillian.spring.testsuite.beans.service.EmployeeService;
import org.jboss.arquillian.spring.testsuite.test.Deployments;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

@RunWith(value=Arquillian.class)
public class CustomConfigurationTestCase {
    @Autowired
    private EmployeeService employeeService;

    @Deployment
    public static Archive createTestArchive() {
        return ((WebArchive)Deployments.createAppDeployment().addAsResource("service.xml")).addAsResource("repository.xml");
    }

    @SpringContextConfiguration
    public static ApplicationContext contextConfiguration() {
        return new ClassPathXmlApplicationContext(new String[]{"service.xml", "repository.xml"});
    }

    @Test
    public void testGetEmployees() {
        List<Employee> result = this.employeeService.getEmployees();
        Assert.assertNotNull((String)"Method returned null list as result.", result);
        Assert.assertEquals((String)"Two employees were expected.", (long)2L, (long)result.size());
    }
}

