/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.testsuite.test;

import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.persistence.Cleanup;
import org.jboss.arquillian.persistence.CleanupStrategy;
import org.jboss.arquillian.persistence.DataSource;
import org.jboss.arquillian.persistence.ShouldMatchDataSet;
import org.jboss.arquillian.persistence.UsingDataSet;
import org.jboss.arquillian.spring.integration.test.annotation.SpringConfiguration;
import org.jboss.arquillian.spring.testsuite.beans.model.Employee;
import org.jboss.arquillian.spring.testsuite.beans.repository.EmployeeRepository;
import org.jboss.arquillian.spring.testsuite.test.Deployments;
import org.jboss.arquillian.transaction.api.annotation.Transactional;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Ignore
@RunWith(value=Arquillian.class)
@Transactional(manager="txManager")
@SpringConfiguration(value={"applicationContext-jpa.xml"})
@DataSource(value="springDataSource")
public class JpaEmployeeRepositoryTestCase {
    @Autowired
    @Qualifier(value="jpaEmployeeRepository")
    private EmployeeRepository employeeRepository;

    @Deployment
    public static Archive createTestArchive() {
        return Deployments.createJpaDeployment();
    }

    @Test
    @ShouldMatchDataSet(value={"employee.yml"}, excludeColumns={"id"})
    public void testSave() {
        Employee employee = new Employee();
        employee.setName("Test employee");
        this.employeeRepository.save(employee);
        employee = new Employee();
        employee.setName("New employee");
        this.employeeRepository.save(employee);
    }

    @Test
    @UsingDataSet(value={"employee.yml"})
    @Cleanup(strategy=CleanupStrategy.USED_TABLES_ONLY)
    public void testGetEmployees() throws Exception {
        List<Employee> result = this.employeeRepository.getEmployees();
        Assert.assertNotNull((String)"Method returned null list as result.", result);
        Assert.assertEquals((String)"Two employees were expected.", (long)2L, (long)result.size());
    }
}

