/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.javaconfig.utils;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import org.jboss.arquillian.spring.integration.test.annotation.SpringAnnotationConfiguration;
import org.jboss.arquillian.spring.integration.test.annotation.SpringClientAnnotationConfiguration;
import org.springframework.context.annotation.Configuration;

public class DefaultConfigurationClassesProcessor {
    public static final String VALIDATION_MESSAGE_SUFFIX_INNER_CLASS_DECLARED_NOT_STATIC = " should be declared static.";
    public static final String VALIDATION_MESSAGE_SUFFIX_INNER_CONFIGURATION_CLASS_DECLARED_FINAL = " must not be declared final.";
    private static final String[] EMPTY_ARRAY = new String[0];

    public Class<?>[] findConfigurationClasses(SpringClientAnnotationConfiguration springConfiguration, Class testClass) {
        if (this.customClassesOrPackagesWereSpecified(springConfiguration)) {
            return springConfiguration.classes();
        }
        return this.defaultConfigurationClasses(testClass);
    }

    public Class<?>[] findConfigurationClasses(SpringAnnotationConfiguration springConfiguration, Class testClass) {
        if (this.customClassesOrPackagesWereSpecified(springConfiguration)) {
            return springConfiguration.classes();
        }
        return this.defaultConfigurationClasses(testClass);
    }

    public String[] findPackages(SpringClientAnnotationConfiguration springConfiguration, Class testClass) {
        if (this.packagesWereDefinedOnAnnotationLevel(springConfiguration)) {
            return springConfiguration.packages();
        }
        return EMPTY_ARRAY;
    }

    public String[] findPackages(SpringAnnotationConfiguration springConfiguration, Class testClass) {
        if (this.packagesWereDefinedOnAnnotationLevel(springConfiguration)) {
            return springConfiguration.packages();
        }
        return EMPTY_ARRAY;
    }

    private boolean packagesWereDefinedOnAnnotationLevel(SpringClientAnnotationConfiguration springConfiguration) {
        return springConfiguration.packages().length > 0;
    }

    private boolean packagesWereDefinedOnAnnotationLevel(SpringAnnotationConfiguration springConfiguration) {
        return springConfiguration.packages().length > 0;
    }

    private boolean customClassesOrPackagesWereSpecified(SpringClientAnnotationConfiguration springConfiguration) {
        return springConfiguration.classes().length > 0 || springConfiguration.packages().length > 0;
    }

    private boolean customClassesOrPackagesWereSpecified(SpringAnnotationConfiguration springConfiguration) {
        return springConfiguration.classes().length > 0 || springConfiguration.packages().length > 0;
    }

    private Class<?>[] defaultConfigurationClasses(Class testClass) {
        Class<?>[] configurationCandidates = testClass.getClasses();
        HashSet configurationClasses = new HashSet();
        for (Class<?> configurationCandidate : configurationCandidates) {
            if (!configurationCandidate.isAnnotationPresent(Configuration.class)) continue;
            this.validateConfigurationCandidate(configurationCandidate);
            configurationClasses.add(configurationCandidate);
        }
        return configurationClasses.toArray(new Class[0]);
    }

    private void validateConfigurationCandidate(Class<?> configurationCandidate) {
        this.throwExceptionIfConfiguratoinClassNotDeclaredStatic(configurationCandidate);
        this.throwExceptionIfConfigurationClassDeclaredFinal(configurationCandidate);
    }

    private void throwExceptionIfConfigurationClassDeclaredFinal(Class<?> configurationCandidate) {
        if (Modifier.isFinal(configurationCandidate.getModifiers())) {
            throw new RuntimeException(this.buildValidationMessage(configurationCandidate, VALIDATION_MESSAGE_SUFFIX_INNER_CONFIGURATION_CLASS_DECLARED_FINAL));
        }
    }

    private void throwExceptionIfConfiguratoinClassNotDeclaredStatic(Class<?> configurationCandidate) {
        if (!Modifier.isStatic(configurationCandidate.getModifiers())) {
            throw new RuntimeException(this.buildValidationMessage(configurationCandidate, VALIDATION_MESSAGE_SUFFIX_INNER_CLASS_DECLARED_NOT_STATIC));
        }
    }

    private String buildValidationMessage(Class<?> configurationCandidate, String validationMessageSuffix) {
        return "Default Java configuration class: " + configurationCandidate + validationMessageSuffix;
    }
}

