/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.graphene.ftest.javascript;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.List;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/**
 * @author Lukas Fryc
 */
@RunWith(Arquillian.class)
public class TestCustomJSInterface {

    @Drone
    WebDriver browser;
    
    @Test
    public void test() {
        browser.navigate().to("http://127.0.0.1:4444");
        
        Document document = JSInterfaceFactory.create(Document.class);
        List<WebElement> elements = document.getElementsByTagName("html");
        assertNotNull(elements);
        assertEquals(1, elements.size());
    }

    @JavaScript("document")
    public static interface Document {
        
        String getTitle();
        
        List<WebElement> getElementsByTagName(String tagName);
    }
}