# How to contribute

Community contributions are essential for maintaining the vitality of the Arquillian project.

Contributing to the project helps to deliver functionality you need and allows you to share your code with other contributors and users.

We want to keep it as easy as possible to contribute your changes and we will work hard to deliver your contributions in an upcoming release.

There are a few guidelines that we need contributors to follow to enable us to manage the process.

## Getting Started

* Check-list:
    * Make sure you have a [JBoss account](http://community.jboss.org/)
    * Make sure you have a [GitHub account](http://github.com/)
    * Submit an [issue report](https://issues.jboss.org/browse/ARQGRA), assuming one does not already exist.
        * Clearly describe the issue including steps to reproduce and environment (Selenium version, browser version).
        * Make sure you fill in the earliest version that you know has the issue.
* Fork the `arquillian-graphene` repository on GitHub

## Making Changes

Make sure the code is [properly formatted](https://community.jboss.org/wiki/ImportFormattingRules).

A common mistake is changing the original line-endings (DOS/unix).

Make sure the patch can be cleanly applied (particular line changes are clearly visible when using `git diff HEAD^` or in GitHub commits history)

## Submitting Changes

* Sign the [Contributor License Agreement](http://cla.jboss.org/) for **Arquillian** project.
* Submit a [pull request](https://help.github.com/articles/creating-a-pull-request)
    * Link the issue to JIRA issue created before ([Guide to use pull requests with GitHub and JIRA](https://community.jboss.org/wiki/GuideToUsePullRequestsWithGitHubAndJIRA))

# Additional Resources

* [Bug tracker (JIRA)](https://issues.jboss.org/browse/ARQGRA)
* [Contributor License Agreement](http://cla.jboss.org/)
* [General GitHub documentation](http://help.github.com/)
* [GitHub pull request documentation](http://help.github.com/send-pull-requests/)
* #arquillian IRC channel on irc.freenode.org
