/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.javascript;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.jboss.arquillian.ajocado.format.SimplifiedFormat;

public class JavaScript {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    String javaScript;

    public JavaScript(String javaScript) {
        this.javaScript = javaScript;
    }

    public static JavaScript js(String javaScript) {
        return new JavaScript(javaScript);
    }

    public String getAsString() {
        return this.javaScript;
    }

    public String toString() {
        return this.getAsString();
    }

    public JavaScript join(JavaScript javaScriptToJoin) {
        return JavaScript.js(this.javaScript + '\n' + javaScriptToJoin.javaScript);
    }

    public JavaScript append(String javaScriptPartToAppend) {
        return JavaScript.js(this.javaScript + javaScriptPartToAppend);
    }

    public String getIdentification() {
        return "richfaces-selenium-script-id" + this.javaScript.hashCode();
    }

    public static JavaScript fromFile(File sourceFile) {
        String sourceCode;
        try {
            sourceCode = JavaScript.inputStreamToString(new FileInputStream(sourceFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Unable to find JavaScript source file '" + sourceFile + "'", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load JavaScript from file '" + sourceFile + "'", e);
        }
        return JavaScript.js(sourceCode);
    }

    public static JavaScript fromResource(String resourceName) {
        String sourceCode;
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(resourceName);
        try {
            sourceCode = JavaScript.inputStreamToString(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load JavaScript from resource with name '" + resourceName + "'", e);
        }
        return JavaScript.js(sourceCode);
    }

    public JavaScript parametrize(Object ... parameters) {
        return JavaScript.js(SimplifiedFormat.format(this.javaScript, parameters));
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        StringWriter output = new StringWriter();
        InputStreamReader input = new InputStreamReader(inputStream);
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toString();
    }
}

