/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.format;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SimplifiedFormat {
    private static final int MAXIMUM = 64;
    private static final int SIXTEEN = 16;
    private static final Pattern PATTERN = Pattern.compile("\\{([0-9]+)\\}");

    private SimplifiedFormat() {
    }

    public static String format(String message, Object ... args) {
        String result = message;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].toString();
            arg = SimplifiedFormat.increaseByDelta(arg, args.length);
            arg = SimplifiedFormat.replace(arg, "{}", "{-1}");
            result = SimplifiedFormat.replaceOnce(result, "{}", arg);
            result = SimplifiedFormat.replace(result, "{" + i + "}", arg);
        }
        result = SimplifiedFormat.decreaseByDelta(result, args.length);
        result = SimplifiedFormat.replace(result, "{-1}", "{}");
        return result;
    }

    private static String decreaseByDelta(String message, int delta) {
        return SimplifiedFormat.increaseByDelta(message, 0 - delta);
    }

    private static String increaseByDelta(String message, int delta) {
        String result = message;
        Matcher matcher = PATTERN.matcher(result);
        LinkedList<Integer> found = new LinkedList<Integer>();
        while (matcher.find()) {
            int value = Integer.valueOf(matcher.group(1));
            found.add(value);
        }
        Collections.sort(found);
        Iterator i$ = found.iterator();
        while (i$.hasNext()) {
            int value = (Integer)i$.next();
            int replacement = value + delta;
            result = SimplifiedFormat.replaceOnce(result, "{" + value + "}", "{" + replacement + "}");
        }
        return result;
    }

    private static String replace(String text, String searchString, String replacement) {
        return SimplifiedFormat.replace(text, searchString, replacement, -1);
    }

    private static String replaceOnce(String text, String searchString, String replacement) {
        return SimplifiedFormat.replace(text, searchString, replacement, 1);
    }

    private static String replace(String text, String searchString, String replacement, int max) {
        int m = max;
        int start = 0;
        int end = text.indexOf(searchString, start);
        if (end == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuffer buf = new StringBuffer(text.length() + (increase *= m < 0 ? 16 : (m > 64 ? 64 : m)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--m == 0) break;
            end = text.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }
}

