/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.drone.example;

import java.io.File;
import java.net.URL;
import org.jboss.arquillian.ajocado.Graphene;
import org.jboss.arquillian.ajocado.drone.example.webapp.Credentials;
import org.jboss.arquillian.ajocado.drone.example.webapp.LoggedIn;
import org.jboss.arquillian.ajocado.drone.example.webapp.Login;
import org.jboss.arquillian.ajocado.drone.example.webapp.User;
import org.jboss.arquillian.ajocado.drone.example.webapp.Users;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.locator.IdLocator;
import org.jboss.arquillian.ajocado.locator.XPathLocator;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GrapheneTestCase {
    @Drone
    GrapheneSelenium driver;
    @ArquillianResource
    URL contextPath;
    protected XPathLocator LOGGED_IN = Graphene.xp((String)"//li[contains(text(),'Welcome')]");
    protected XPathLocator LOGGED_OUT = Graphene.xp((String)"//li[contains(text(),'Goodbye')]");
    protected IdLocator USERNAME_FIELD = Graphene.id((String)"loginForm:username");
    protected IdLocator PASSWORD_FIELD = Graphene.id((String)"loginForm:password");
    protected IdLocator LOGIN_BUTTON = Graphene.id((String)"loginForm:login");
    protected IdLocator LOGOUT_BUTTON = Graphene.id((String)"loginForm:logout");

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"weld-login.war")).addClasses(new Class[]{Credentials.class, LoggedIn.class, Login.class, User.class, Users.class})).addAsWebInfResource(new File("src/test/webapp/WEB-INF/beans.xml"))).addAsWebInfResource(new File("src/test/webapp/WEB-INF/faces-config.xml"))).addAsWebInfResource(new File("src/test/resources/import.sql"))).addAsWebResource(new File("src/test/webapp/index.html"))).addAsWebResource(new File("src/test/webapp/home.xhtml"))).addAsWebResource(new File("src/test/webapp/template.xhtml"))).addAsWebResource(new File("src/test/webapp/users.xhtml"))).addAsResource(new File("src/test/resources/META-INF/persistence.xml"), ArchivePaths.create((String)"META-INF/persistence.xml"))).addAsResource(new File("src/test/resources/import.sql"), ArchivePaths.create((String)"import.sql"))).setWebXML(new File("src/test/webapp/WEB-INF/web.xml"));
        return war;
    }

    @Test
    public void testLoginAndLogout() {
        Assert.assertNotNull((String)"Path is not null", (Object)this.contextPath);
        Assert.assertNotNull((String)"AjaxSelenium is not null", (Object)this.driver);
        this.driver.open(this.contextPath);
        Graphene.waitModel.until((SeleniumCondition)Graphene.elementPresent.locator((ElementLocator)this.USERNAME_FIELD));
        Assert.assertFalse((String)"User should not be logged in!", (boolean)this.driver.isElementPresent((ElementLocator)this.LOGOUT_BUTTON));
        this.driver.type((ElementLocator)this.USERNAME_FIELD, "demo");
        this.driver.type((ElementLocator)this.PASSWORD_FIELD, "demo");
        Graphene.guardHttp((GrapheneSelenium)this.driver).click((ElementLocator)this.LOGIN_BUTTON);
        Assert.assertTrue((String)"User should be logged in!", (boolean)this.driver.isElementPresent((ElementLocator)this.LOGGED_IN));
        Graphene.guardHttp((GrapheneSelenium)this.driver).click((ElementLocator)this.LOGOUT_BUTTON);
        Assert.assertTrue((String)"User should not be logged in!", (boolean)this.driver.isElementPresent((ElementLocator)this.LOGGED_OUT));
    }
}

