/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.junit.ftest;

import org.jboss.arquillian.ajocado.Graphene;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.junit.ftest.SampleApplication;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class RequestGuardTimingTestCase
extends SampleApplication {
    private JavaScript twoClicksWithTimeout = JavaScript.fromResource((String)"two-clicks-with-timeout.js");
    private ElementLocator<?> linkNoRequest = Graphene.id((String)"noRequest");
    private ElementLocator<?> linkAjaxRequest = Graphene.id((String)"ajax");
    private ElementLocator<?> linkHttpRequest = Graphene.id((String)"http");

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return RequestGuardTimingTestCase.createDeploymentForClass(RequestGuardTimingTestCase.class);
    }

    @Test
    public void testGuardXhrTiming() {
        this.openContext();
        long time = System.currentTimeMillis();
        Graphene.guardXhr((GrapheneSelenium)this.selenium).click(this.linkAjaxRequest);
        Assert.assertTrue((String)"The intercepting of ajax request should not last more than 1 sec", ((time -= System.currentTimeMillis()) > -1000L ? 1 : 0) != 0);
    }

    @Test
    public void testGuardHttpTiming() {
        this.openContext();
        long time = System.currentTimeMillis();
        Graphene.guardHttp((GrapheneSelenium)this.selenium).click(this.linkHttpRequest);
        Assert.assertTrue((String)"The intercepting of the http request should not last more than 1 sec", ((time -= System.currentTimeMillis()) > -1000L ? 1 : 0) != 0);
    }

    @Test
    public void testGuardNoneTiming() {
        this.openContext();
        long time = System.currentTimeMillis();
        Graphene.guardNoRequest((GrapheneSelenium)this.selenium).click(this.linkNoRequest);
        Assert.assertTrue((String)"The checking of none request should last more than 5 sec", ((time -= System.currentTimeMillis()) < -5000L ? 1 : 0) != 0);
    }

    @Test
    public void testWaitHttpTiming() {
        this.openContext();
        long time = System.currentTimeMillis();
        Graphene.waitForHttp((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkAjaxRequest, this.linkHttpRequest}));
        Assert.assertTrue(((time -= System.currentTimeMillis()) < -5000L ? 1 : 0) != 0);
    }

    @Test
    public void testWaitForXhrTiming() {
        this.openContext();
        long time = System.currentTimeMillis();
        Graphene.waitForXhr((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkHttpRequest, this.linkAjaxRequest}));
        Assert.assertTrue(((time -= System.currentTimeMillis()) < -5000L ? 1 : 0) != 0);
    }
}

