/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.testng.ftest;

import org.jboss.arquillian.ajocado.Graphene;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.testng.ftest.AbstractTest;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRequestGuardTiming
extends AbstractTest {
    private JavaScript twoClicksWithTimeout = JavaScript.fromResource((String)"two-clicks-with-timeout.js");
    private ElementLocator<?> linkNoRequest = Graphene.id((String)"noRequest");
    private ElementLocator<?> linkAjaxRequest = Graphene.id((String)"ajax");
    private ElementLocator<?> linkHttpRequest = Graphene.id((String)"http");

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return TestRequestGuardTiming.createDeploymentForClass(TestRequestGuardTiming.class);
    }

    @Test
    public void testGuardXhrTiming() {
        long time = System.currentTimeMillis();
        Graphene.guardXhr((GrapheneSelenium)this.selenium).click(this.linkAjaxRequest);
        Assert.assertTrue(((time -= System.currentTimeMillis()) > -1000L ? 1 : 0) != 0, (String)"The intercepting of ajax request should not last more than 1 sec");
    }

    @Test
    public void testGuardHttpTiming() {
        long time = System.currentTimeMillis();
        Graphene.guardHttp((GrapheneSelenium)this.selenium).click(this.linkHttpRequest);
        Assert.assertTrue(((time -= System.currentTimeMillis()) > -1000L ? 1 : 0) != 0, (String)"The intercepting of the http request should not last more than 1 sec");
    }

    @Test
    public void testGuardNoneTiming() {
        long time = System.currentTimeMillis();
        Graphene.guardNoRequest((GrapheneSelenium)this.selenium).click(this.linkNoRequest);
        Assert.assertTrue(((time -= System.currentTimeMillis()) < -5000L ? 1 : 0) != 0, (String)"The checking of none request should last more than 5 sec");
    }

    @Test
    public void testWaitHttpTiming() {
        long time = System.currentTimeMillis();
        Graphene.waitForHttp((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkAjaxRequest, this.linkHttpRequest}));
        Assert.assertTrue(((time -= System.currentTimeMillis()) < -5000L ? 1 : 0) != 0);
    }

    @Test
    public void testWaitForXhrTiming() {
        long time = System.currentTimeMillis();
        Graphene.waitForXhr((GrapheneSelenium)this.selenium).getEval(this.twoClicksWithTimeout.parametrize(new Object[]{this.linkHttpRequest, this.linkAjaxRequest}));
        Assert.assertTrue(((time -= System.currentTimeMillis()) < -5000L ? 1 : 0) != 0);
    }
}

