/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.attribute.AttributeLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeEquals
implements SeleniumCondition,
JavaScriptCondition {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private AttributeLocator<?> attributeLocator;
    private String value;

    protected AttributeEquals() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.attributeLocator);
        Validate.notNull((Object)this.value);
        return this.selenium.getAttribute(this.attributeLocator).equals(this.value);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedElementLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.getAssociatedElement().inSeleniumRepresentation());
        String escapedAttributeLocator = StringEscapeUtils.escapeJavaScript((String)this.attributeLocator.inSeleniumRepresentation());
        String escapedValue = StringEscapeUtils.escapeJavaScript((String)this.value);
        return JavaScript.js((String)"selenium.isElementPresent('{0}') && (selenium.getAttribute('{1}') == '{2}')").parametrize(new Object[]{escapedElementLocator, escapedAttributeLocator, escapedValue});
    }

    public static AttributeEquals getInstance() {
        return new AttributeEquals();
    }

    public AttributeEquals locator(AttributeLocator<?> attributeLocator) {
        Validate.notNull(attributeLocator);
        AttributeEquals copy = this.copy();
        copy.attributeLocator = attributeLocator;
        return copy;
    }

    public AttributeEquals text(String value) {
        Validate.notNull((Object)value);
        AttributeEquals copy = this.copy();
        copy.value = value;
        return copy;
    }

    private AttributeEquals copy() {
        AttributeEquals copy = new AttributeEquals();
        copy.attributeLocator = this.attributeLocator;
        copy.value = this.value;
        return copy;
    }
}

