/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementNotPresent
implements SeleniumCondition,
JavaScriptCondition {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private ElementLocator<?> elementLocator;

    protected ElementNotPresent() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.elementLocator);
        return !this.selenium.isElementPresent(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.inSeleniumRepresentation());
        return JavaScript.js((String)"!selenium.isElementPresent('{0}')").parametrize(new Object[]{escapedLocator});
    }

    public static ElementNotPresent getInstance() {
        return new ElementNotPresent();
    }

    public ElementNotPresent locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        ElementNotPresent copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private ElementNotPresent copy() {
        ElementNotPresent copy = new ElementNotPresent();
        copy.elementLocator = this.elementLocator;
        return copy;
    }
}

