/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;
import org.jboss.arquillian.ajocado.css.CssProperty;
import org.jboss.arquillian.ajocado.css.CssResolver;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleEquals
implements SeleniumCondition,
JavaScriptCondition {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private ElementLocator<?> elementLocator;
    private CssProperty cssProperty;
    private String value;

    protected StyleEquals() {
    }

    @Override
    public boolean isTrue() {
        this.validate();
        return this.selenium.getStyle(this.elementLocator, (CssResolver)this.cssProperty).equals(this.value);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        this.validate();
        String escapedLocator = StringEscapeUtils.escapeJavaScript((String)this.elementLocator.inSeleniumRepresentation());
        String escapedCssProperty = StringEscapeUtils.escapeJavaScript((String)this.cssProperty.getPropertyName());
        String escapedText = StringEscapeUtils.escapeJavaScript((String)this.value);
        return JavaScript.js((String)"selenium.isElementPresent('{0}') && (selenium.getStyle('{0}', '{1}') == '{2}')").parametrize(new Object[]{escapedLocator, escapedCssProperty, escapedText});
    }

    private void validate() {
        Validate.notNull(this.elementLocator);
        Validate.notNull((Object)this.cssProperty);
        Validate.notNull((Object)this.value);
    }

    public static StyleEquals getInstance() {
        return new StyleEquals();
    }

    public StyleEquals locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator);
        StyleEquals copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    public StyleEquals property(CssProperty cssProperty) {
        Validate.notNull((Object)cssProperty);
        StyleEquals copy = this.copy();
        copy.cssProperty = cssProperty;
        return copy;
    }

    public StyleEquals value(String value) {
        Validate.notNull((Object)value);
        StyleEquals copy = this.copy();
        copy.value = value;
        return copy;
    }

    private StyleEquals copy() {
        StyleEquals copy = new StyleEquals();
        copy.elementLocator = this.elementLocator;
        copy.cssProperty = this.cssProperty;
        copy.value = this.value;
        return copy;
    }
}

