/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang3.StringEscapeUtils;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocationStrategy;
import org.jboss.arquillian.ajocado.locator.element.IterableLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;
import org.jboss.arquillian.core.spi.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountEquals
implements SeleniumCondition,
JavaScriptCondition {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private IterableLocator<?> iterableLocator;
    private Integer count;

    protected CountEquals() {
    }

    @Override
    public boolean isTrue() {
        this.validate();
        return this.selenium.getCount(this.iterableLocator) == this.count.intValue();
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        this.validate();
        String escapedRawLocator = StringEscapeUtils.escapeEcmaScript((String)this.iterableLocator.getRawLocator());
        String countFunction = this.iterableLocator.getLocationStrategy() == ElementLocationStrategy.JQUERY ? "getJQueryCount" : "getXPathCount";
        return JavaScript.js((String)"selenium.{0}('{1}') == {2}").parametrize(new Object[]{countFunction, escapedRawLocator, this.count});
    }

    private void validate() {
        Validate.notNull(this.iterableLocator, (String)"iterableLocator should not be null");
        Validate.notNull((Object)this.count, (String)"count should not be null");
    }

    public static CountEquals getInstance() {
        return new CountEquals();
    }

    public CountEquals locator(IterableLocator<?> iterableLocator) {
        Validate.notNull(iterableLocator, (String)"iterableLocator should not be null");
        if (iterableLocator.getLocationStrategy() != ElementLocationStrategy.JQUERY && iterableLocator.getLocationStrategy() != ElementLocationStrategy.XPATH) {
            throw new IllegalArgumentException("Only XPath and JQuery locators are supported for counting");
        }
        CountEquals copy = this.copy();
        copy.iterableLocator = iterableLocator;
        return copy;
    }

    public CountEquals count(int count) {
        CountEquals copy = this.copy();
        copy.count = count;
        return copy;
    }

    private CountEquals copy() {
        CountEquals copy = new CountEquals();
        copy.iterableLocator = this.iterableLocator;
        copy.count = this.count;
        return copy;
    }
}

