/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting.conditions;

import org.apache.commons.lang3.StringEscapeUtils;
import org.jboss.arquillian.ajocado.format.SimplifiedFormat;
import org.jboss.arquillian.ajocado.framework.GrapheneSelenium;
import org.jboss.arquillian.ajocado.framework.GrapheneSeleniumContext;
import org.jboss.arquillian.ajocado.javascript.JavaScript;
import org.jboss.arquillian.ajocado.locator.element.ElementLocator;
import org.jboss.arquillian.ajocado.waiting.ajax.JavaScriptCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;
import org.jboss.arquillian.core.spi.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementNotVisible
implements SeleniumCondition,
JavaScriptCondition {
    private GrapheneSelenium selenium = GrapheneSeleniumContext.getProxy();
    private ElementLocator<?> elementLocator;

    protected ElementNotVisible() {
    }

    @Override
    public boolean isTrue() {
        Validate.notNull(this.elementLocator, (String)"elementLocator should not be null");
        return !this.selenium.isVisible(this.elementLocator);
    }

    @Override
    public JavaScript getJavaScriptCondition() {
        String escapedLocator = StringEscapeUtils.escapeEcmaScript((String)this.elementLocator.inSeleniumRepresentation());
        return JavaScript.js((String)SimplifiedFormat.format((String)"!selenium.isVisible('{0}')", (Object[])new Object[]{escapedLocator}));
    }

    public static ElementNotVisible getInstance() {
        return new ElementNotVisible();
    }

    public ElementNotVisible locator(ElementLocator<?> elementLocator) {
        Validate.notNull(elementLocator, (String)"elementLocator should not be null");
        ElementNotVisible copy = this.copy();
        copy.elementLocator = elementLocator;
        return copy;
    }

    private ElementNotVisible copy() {
        ElementNotVisible copy = new ElementNotVisible();
        copy.elementLocator = this.elementLocator;
        return copy;
    }
}

