/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado;

import org.jboss.arquillian.ajocado.Graphene;
import org.jboss.arquillian.ajocado.framework.GrapheneConfiguration;
import org.jboss.arquillian.ajocado.framework.GrapheneConfigurationContext;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestGraphene {
    private static final long TIMEOUT = 500L;
    private static final long TOLERANCE = 1000L;
    private static final int LOOPS = 8;
    @Mock
    GrapheneConfiguration configuration;

    @BeforeMethod
    public void initMocks() {
        MockitoAnnotations.initMocks((Object)this);
        GrapheneConfigurationContext.set((GrapheneConfiguration)this.configuration);
    }

    @Test
    public void testAjaxWaitTimeoutConfiguration() {
        Mockito.when((Object)this.configuration.getTimeout((GrapheneConfiguration.TimeoutType)Matchers.any(GrapheneConfiguration.TimeoutType.class))).thenReturn((Object)500L);
        long runtime = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            Graphene.waitGui.waitForTimeout();
        }
        runtime = System.currentTimeMillis() - runtime;
        Assert.assertTrue(((runtime /= 8L) > 500L ? 1 : 0) != 0, (String)("runtime (" + runtime + ") is less than TIMEOUT=" + 500L));
        Assert.assertTrue((runtime < 1500L ? 1 : 0) != 0, (String)("runtime (" + runtime + ") is greater than TIMEOUT + TOLERANCE = " + 500L + " + " + 1000L + " = " + 1500L));
    }
}

