/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.utils.text;

import org.jboss.arquillian.ajocado.dom.Attribute;
import org.jboss.arquillian.ajocado.locator.JQueryLocator;
import org.jboss.arquillian.ajocado.locator.LocatorFactory;
import org.jboss.arquillian.ajocado.locator.attribute.AttributeLocator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFormattingLocators {
    @Test
    public void testBackReference() {
        Assert.assertEquals((String)LocatorFactory.jq((String)"input[id$=myId]").inSeleniumRepresentation(), (String)"jquery=input[id$=myId]");
    }

    @Test
    public void testSimpleFormatting() {
        JQueryLocator locator = LocatorFactory.jq((String)"x{0}z");
        locator = locator.format(new Object[]{"y"});
        Assert.assertEquals((String)locator.inSeleniumRepresentation(), (String)"jquery=xyz");
    }

    @Test
    public void testDoubleFormatting() {
        JQueryLocator locator = LocatorFactory.jq((String)"a{0}c{1}e");
        locator = locator.format(new Object[]{"b"});
        locator = locator.format(new Object[]{"d"});
        Assert.assertEquals((String)locator.inSeleniumRepresentation(), (String)"jquery=abcde");
    }

    @Test
    public void testComplexFormatting() {
        JQueryLocator locator = LocatorFactory.jq((String)"a{1}b{3}c{}{4}d{}e{}f");
        locator = locator.format(new Object[]{0, 1});
        locator = locator.format(new Object[]{2, 3});
        locator = locator.format(new Object[]{4});
        Assert.assertEquals((String)locator.inSeleniumRepresentation(), (String)"jquery=a1b3c04d1e2f");
    }

    @Test
    public void testAttributeFormatting() {
        JQueryLocator locator = LocatorFactory.jq((String)"x{0}z");
        AttributeLocator attributeLocator = locator.getAttribute(Attribute.CLASS);
        attributeLocator = attributeLocator.format(new Object[]{"y"});
        Assert.assertEquals((Object)attributeLocator.getAttribute(), (Object)Attribute.CLASS);
        Assert.assertEquals((String)attributeLocator.getAssociatedElement().inSeleniumRepresentation(), (String)"jquery=xyz");
        Assert.assertEquals((String)attributeLocator.inSeleniumRepresentation(), (String)"jquery=xyz@class");
    }
}

