/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.utils.text;

import org.jboss.arquillian.ajocado.format.SimplifiedFormat;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSimpleFormatting {
    Object[] simpleParameters = new Object[]{1, "2", Character.valueOf('3')};
    Object[] parametrizedParameters = new Object[]{"{}{1}{3}{0}{}{2}", "{1}{}{3}{0}{}{2}", "{3}{1}{}{0}{}{2}"};

    @Test
    public void testSimpleWithoutNumbers() {
        Assert.assertEquals((String)"a1b2c3d", (String)SimplifiedFormat.format((String)"a{}b{}c{}d", (Object[])this.simpleParameters));
    }

    @Test
    public void testSimpleWithNumbers() {
        Assert.assertEquals((String)"a1b2c3d", (String)SimplifiedFormat.format((String)"a{0}b{1}c{2}d", (Object[])this.simpleParameters));
    }

    @Test
    public void testSimpleWithNumbersNotInOrder() {
        Assert.assertEquals((String)"a3b1c2d", (String)SimplifiedFormat.format((String)"a{2}b{0}c{1}d", (Object[])this.simpleParameters));
    }

    @Test
    public void testParametrizedParametersWithoutNumbers() {
        Assert.assertEquals((String)"a{}{1}{3}{0}{}{2}b{1}{}{3}{0}{}{2}c{3}{1}{}{0}{}{2}d", (String)SimplifiedFormat.format((String)"a{}b{}c{}d", (Object[])this.parametrizedParameters));
    }

    @Test
    public void testParametrizedParametersWithNumbers() {
        Assert.assertEquals((String)"a{}{1}{3}{0}{}{2}b{1}{}{3}{0}{}{2}c{3}{1}{}{0}{}{2}d", (String)SimplifiedFormat.format((String)"a{0}b{1}c{2}d", (Object[])this.parametrizedParameters));
    }

    @Test
    public void testParametrizedParametersWithNumbersNotInOrder() {
        Assert.assertEquals((String)"a{3}{1}{}{0}{}{2}b{}{1}{3}{0}{}{2}c{1}{}{3}{0}{}{2}d", (String)SimplifiedFormat.format((String)"a{2}b{0}c{1}d", (Object[])this.parametrizedParameters));
    }
}

