/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.waiting;

import org.jboss.arquillian.ajocado.waiting.WaitTimeoutException;
import org.jboss.arquillian.ajocado.waiting.selenium.DefaultSeleniumWaiting;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumCondition;
import org.jboss.arquillian.ajocado.waiting.selenium.SeleniumWaiting;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestWaitingFailure {
    SeleniumWaiting seleniumWaiting;
    private final SeleniumCondition failureCondition = new SeleniumCondition(){

        public boolean isTrue() {
            return false;
        }
    };

    @BeforeClass
    public void setupSeleniumWaiting() {
        this.seleniumWaiting = (SeleniumWaiting)new DefaultSeleniumWaiting().timeout(1L);
    }

    @Test
    public void testDefault() {
        try {
            this.seleniumWaiting.until(this.failureCondition);
            Assert.fail();
        }
        catch (WaitTimeoutException waitTimeoutException) {
            // empty catch block
        }
    }

    @Test
    public void testCustomRuntimeException() {
        RuntimeException exception = new RuntimeException();
        try {
            ((SeleniumWaiting)this.seleniumWaiting.failWith((Exception)exception)).until(this.failureCondition);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertSame((Object)e, (Object)exception);
        }
    }

    @Test
    public void testCustomException() {
        Exception exception = new Exception();
        try {
            ((SeleniumWaiting)this.seleniumWaiting.failWith(exception)).until(this.failureCondition);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertSame((Object)e.getCause(), (Object)exception);
        }
    }

    @Test
    public void testMessage() {
        String message = "some message";
        try {
            ((SeleniumWaiting)this.seleniumWaiting.failWith((CharSequence)message, new Object[0])).until(this.failureCondition);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof WaitTimeoutException));
            Assert.assertEquals((String)e.getMessage(), (String)message);
        }
    }

    @Test
    public void testDontFail() {
        ((SeleniumWaiting)this.seleniumWaiting.dontFail()).until(this.failureCondition);
    }
}

