/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.ajocado.ajaxaware;

import com.thoughtworks.selenium.SeleniumException;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.ajocado.Graphene;
import org.jboss.arquillian.ajocado.command.CommandContext;
import org.jboss.arquillian.ajocado.command.CommandInterceptor;
import org.jboss.arquillian.ajocado.command.CommandInterceptorException;
import org.jboss.arquillian.ajocado.framework.GrapheneConfiguration;
import org.jboss.arquillian.ajocado.framework.GrapheneConfigurationContext;
import org.jboss.arquillian.ajocado.waiting.Waiting;

public class AjaxAwareInterceptor
implements CommandInterceptor {
    private static final List<String> PERMISSION_DENIED = Arrays.asList("ERROR: Threw an exception: Permission denied", "ERROR: Command execution failure. Please search the forum at http://clearspace.openqa.org for error details from the log window.  The error message is: Permission denied", "ERROR: Threw an exception: Error executing strategy function jquery: Permission denied");
    private final GrapheneConfiguration configuration = GrapheneConfigurationContext.getProxy();
    private final Waiting<?> wait = Graphene.waitAjax;

    public void intercept(CommandContext ctx) throws CommandInterceptorException {
        long end = System.currentTimeMillis() + this.configuration.getTimeout(GrapheneConfiguration.TimeoutType.AJAX);
        boolean exceptionLogged = false;
        while (System.currentTimeMillis() < end) {
            try {
                ctx.invoke();
                return;
            }
            catch (SeleniumException e) {
                String message;
                String string = message = e.getMessage() == null ? "" : e.getMessage();
                if (PERMISSION_DENIED.contains(message)) {
                    System.err.println(message);
                    if (!exceptionLogged) {
                        exceptionLogged = true;
                        System.err.println(ctx.toString());
                        e.printStackTrace();
                    }
                    this.wait.waitForTimeout();
                    continue;
                }
                throw e;
            }
        }
        throw new PermissionDeniedException("Fails with 'Permission denied' errors when trying to execute jQuery");
    }

    public static class PermissionDeniedException
    extends RuntimeException {
        private static final long serialVersionUID = 501755400552888059L;

        public PermissionDeniedException(String message) {
            super(message);
        }
    }
}

